/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.java.generator.testing;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.github.difflib.text.DiffRow;
import com.github.difflib.text.DiffRowGenerator;
import io.fabric8.zjsonpatch.JsonDiff;
import io.fabric8.zjsonpatch.JsonPatch;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class KubernetesResourceDiff {
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String ANSI_RED = "\u001b[31m";
    private static final String ANSI_GREEN = "\u001b[32m";
    private final String source1;
    private final String source2;
    private final ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER));

    public KubernetesResourceDiff(String source1, String source2) {
        this.source1 = source1;
        this.source2 = source2;
    }

    public List<JsonNode> getListOfDiffs() {
        try {
            JsonNode source1Json = this.yamlMapper.readTree(this.source1);
            JsonNode source2Json = this.yamlMapper.readTree(this.source2);
            JsonNode diff = JsonDiff.asJson((JsonNode)source1Json, (JsonNode)source2Json);
            List<JsonNode> aggregatedDiffs = StreamSupport.stream(diff.spliterator(), false).collect(Collectors.toList());
            if (!aggregatedDiffs.isEmpty()) {
                JsonNode generatedDiff = JsonPatch.apply((JsonNode)diff, (JsonNode)source1Json);
                DiffRowGenerator generator = DiffRowGenerator.create().showInlineDiffs(true).inlineDiffByWord(true).oldTag(b -> Boolean.TRUE.equals(b) ? ANSI_RED : ANSI_RESET).newTag(b -> Boolean.TRUE.equals(b) ? ANSI_GREEN : ANSI_RESET).build();
                List rows = generator.generateDiffRows(Arrays.asList(this.yamlMapper.writeValueAsString((Object)source1Json).split("\n")), Arrays.asList(this.yamlMapper.writeValueAsString((Object)generatedDiff).split("\n")));
                int maxWidth = 0;
                for (DiffRow row : rows) {
                    maxWidth = Math.max(maxWidth, Math.max(row.getOldLine().getBytes(StandardCharsets.UTF_8).length, row.getNewLine().getBytes(StandardCharsets.UTF_8).length));
                }
                for (DiffRow row : rows) {
                    System.err.printf("%-" + maxWidth + "s %-" + maxWidth + "s\n", row.getOldLine(), row.getNewLine());
                }
            }
            return aggregatedDiffs;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

