/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.authentication;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.authentication.TokenReviewStatus;
import io.fabric8.kubernetes.api.model.authentication.UserInfo;
import io.fabric8.kubernetes.api.model.authentication.UserInfoBuilder;
import io.fabric8.kubernetes.api.model.authentication.UserInfoFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class TokenReviewStatusFluent<A extends TokenReviewStatusFluent<A>>
extends BaseFluent<A> {
    private List<String> audiences = new ArrayList<String>();
    private Boolean authenticated;
    private String error;
    private UserInfoBuilder user;
    private Map<String, Object> additionalProperties;

    public TokenReviewStatusFluent() {
    }

    public TokenReviewStatusFluent(TokenReviewStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(TokenReviewStatus instance) {
        TokenReviewStatus tokenReviewStatus = instance = instance != null ? instance : new TokenReviewStatus();
        if (instance != null) {
            this.withAudiences(instance.getAudiences());
            this.withAuthenticated(instance.getAuthenticated());
            this.withError(instance.getError());
            this.withUser(instance.getUser());
            this.withAudiences(instance.getAudiences());
            this.withAuthenticated(instance.getAuthenticated());
            this.withError(instance.getError());
            this.withUser(instance.getUser());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAudiences(int index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.add(index, item);
        return (A)this;
    }

    public A setToAudiences(int index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.set(index, item);
        return (A)this;
    }

    public A addToAudiences(String ... items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)this;
    }

    public A addAllToAudiences(Collection<String> items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)this;
    }

    public A removeFromAudiences(String ... items) {
        if (this.audiences == null) {
            return (A)this;
        }
        for (String item : items) {
            this.audiences.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromAudiences(Collection<String> items) {
        if (this.audiences == null) {
            return (A)this;
        }
        for (String item : items) {
            this.audiences.remove(item);
        }
        return (A)this;
    }

    public List<String> getAudiences() {
        return this.audiences;
    }

    public String getAudience(int index) {
        return this.audiences.get(index);
    }

    public String getFirstAudience() {
        return this.audiences.get(0);
    }

    public String getLastAudience() {
        return this.audiences.get(this.audiences.size() - 1);
    }

    public String getMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAudiences(List<String> audiences) {
        if (audiences != null) {
            this.audiences = new ArrayList<String>();
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        } else {
            this.audiences = null;
        }
        return (A)this;
    }

    public A withAudiences(String ... audiences) {
        if (this.audiences != null) {
            this.audiences.clear();
            this._visitables.remove("audiences");
        }
        if (audiences != null) {
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        }
        return (A)this;
    }

    public boolean hasAudiences() {
        return this.audiences != null && !this.audiences.isEmpty();
    }

    public Boolean getAuthenticated() {
        return this.authenticated;
    }

    public A withAuthenticated(Boolean authenticated) {
        this.authenticated = authenticated;
        return (A)this;
    }

    public boolean hasAuthenticated() {
        return this.authenticated != null;
    }

    public String getError() {
        return this.error;
    }

    public A withError(String error) {
        this.error = error;
        return (A)this;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public UserInfo buildUser() {
        return this.user != null ? this.user.build() : null;
    }

    public A withUser(UserInfo user) {
        this._visitables.remove(this.user);
        if (user != null) {
            this.user = new UserInfoBuilder(user);
            this._visitables.get("user").add(this.user);
        } else {
            this.user = null;
            this._visitables.get("user").remove(this.user);
        }
        return (A)this;
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public UserNested<A> withNewUser() {
        return new UserNested(null);
    }

    public UserNested<A> withNewUserLike(UserInfo item) {
        return new UserNested(item);
    }

    public UserNested<A> editUser() {
        return this.withNewUserLike(Optional.ofNullable(this.buildUser()).orElse(null));
    }

    public UserNested<A> editOrNewUser() {
        return this.withNewUserLike(Optional.ofNullable(this.buildUser()).orElse(new UserInfoBuilder().build()));
    }

    public UserNested<A> editOrNewUserLike(UserInfo item) {
        return this.withNewUserLike(Optional.ofNullable(this.buildUser()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TokenReviewStatusFluent that = (TokenReviewStatusFluent)o;
        if (!Objects.equals(this.audiences, that.audiences)) {
            return false;
        }
        if (!Objects.equals(this.authenticated, that.authenticated)) {
            return false;
        }
        if (!Objects.equals(this.error, that.error)) {
            return false;
        }
        if (!Objects.equals(this.user, that.user)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.audiences, this.authenticated, this.error, this.user, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.audiences != null && !this.audiences.isEmpty()) {
            sb.append("audiences:");
            sb.append(this.audiences + ",");
        }
        if (this.authenticated != null) {
            sb.append("authenticated:");
            sb.append(this.authenticated + ",");
        }
        if (this.error != null) {
            sb.append("error:");
            sb.append(this.error + ",");
        }
        if (this.user != null) {
            sb.append("user:");
            sb.append(this.user + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAuthenticated() {
        return this.withAuthenticated(true);
    }

    public class UserNested<N>
    extends UserInfoFluent<UserNested<N>>
    implements Nested<N> {
        UserInfoBuilder builder;

        UserNested(UserInfo item) {
            this.builder = new UserInfoBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)TokenReviewStatusFluent.this.withUser(this.builder.build());
        }

        public N endUser() {
            return this.and();
        }
    }
}

