/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCHeaderMatch;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCHeaderMatchBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCHeaderMatchFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCMethodMatch;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCMethodMatchBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCMethodMatchFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteMatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class GRPCRouteMatchFluent<A extends GRPCRouteMatchFluent<A>>
extends BaseFluent<A> {
    private ArrayList<GRPCHeaderMatchBuilder> headers = new ArrayList();
    private GRPCMethodMatchBuilder method;
    private Map<String, Object> additionalProperties;

    public GRPCRouteMatchFluent() {
    }

    public GRPCRouteMatchFluent(GRPCRouteMatch instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(GRPCRouteMatch instance) {
        GRPCRouteMatch gRPCRouteMatch = instance = instance != null ? instance : new GRPCRouteMatch();
        if (instance != null) {
            this.withHeaders(instance.getHeaders());
            this.withMethod(instance.getMethod());
            this.withHeaders(instance.getHeaders());
            this.withMethod(instance.getMethod());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToHeaders(int index, GRPCHeaderMatch item) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        GRPCHeaderMatchBuilder builder = new GRPCHeaderMatchBuilder(item);
        if (index < 0 || index >= this.headers.size()) {
            this._visitables.get("headers").add(builder);
            this.headers.add(builder);
        } else {
            this._visitables.get("headers").add(index, builder);
            this.headers.add(index, builder);
        }
        return (A)this;
    }

    public A setToHeaders(int index, GRPCHeaderMatch item) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        GRPCHeaderMatchBuilder builder = new GRPCHeaderMatchBuilder(item);
        if (index < 0 || index >= this.headers.size()) {
            this._visitables.get("headers").add(builder);
            this.headers.add(builder);
        } else {
            this._visitables.get("headers").set(index, builder);
            this.headers.set(index, builder);
        }
        return (A)this;
    }

    public A addToHeaders(GRPCHeaderMatch ... items) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        for (GRPCHeaderMatch item : items) {
            GRPCHeaderMatchBuilder builder = new GRPCHeaderMatchBuilder(item);
            this._visitables.get("headers").add(builder);
            this.headers.add(builder);
        }
        return (A)this;
    }

    public A addAllToHeaders(Collection<GRPCHeaderMatch> items) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        for (GRPCHeaderMatch item : items) {
            GRPCHeaderMatchBuilder builder = new GRPCHeaderMatchBuilder(item);
            this._visitables.get("headers").add(builder);
            this.headers.add(builder);
        }
        return (A)this;
    }

    public A removeFromHeaders(GRPCHeaderMatch ... items) {
        if (this.headers == null) {
            return (A)this;
        }
        for (GRPCHeaderMatch item : items) {
            GRPCHeaderMatchBuilder builder = new GRPCHeaderMatchBuilder(item);
            this._visitables.get("headers").remove(builder);
            this.headers.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromHeaders(Collection<GRPCHeaderMatch> items) {
        if (this.headers == null) {
            return (A)this;
        }
        for (GRPCHeaderMatch item : items) {
            GRPCHeaderMatchBuilder builder = new GRPCHeaderMatchBuilder(item);
            this._visitables.get("headers").remove(builder);
            this.headers.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromHeaders(Predicate<GRPCHeaderMatchBuilder> predicate) {
        if (this.headers == null) {
            return (A)this;
        }
        Iterator<GRPCHeaderMatchBuilder> each = this.headers.iterator();
        Object visitables = this._visitables.get("headers");
        while (each.hasNext()) {
            GRPCHeaderMatchBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<GRPCHeaderMatch> buildHeaders() {
        return this.headers != null ? GRPCRouteMatchFluent.build(this.headers) : null;
    }

    public GRPCHeaderMatch buildHeader(int index) {
        return this.headers.get(index).build();
    }

    public GRPCHeaderMatch buildFirstHeader() {
        return this.headers.get(0).build();
    }

    public GRPCHeaderMatch buildLastHeader() {
        return this.headers.get(this.headers.size() - 1).build();
    }

    public GRPCHeaderMatch buildMatchingHeader(Predicate<GRPCHeaderMatchBuilder> predicate) {
        for (GRPCHeaderMatchBuilder item : this.headers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingHeader(Predicate<GRPCHeaderMatchBuilder> predicate) {
        for (GRPCHeaderMatchBuilder item : this.headers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHeaders(List<GRPCHeaderMatch> headers) {
        if (this.headers != null) {
            this._visitables.get("headers").clear();
        }
        if (headers != null) {
            this.headers = new ArrayList();
            for (GRPCHeaderMatch item : headers) {
                this.addToHeaders(item);
            }
        } else {
            this.headers = null;
        }
        return (A)this;
    }

    public A withHeaders(GRPCHeaderMatch ... headers) {
        if (this.headers != null) {
            this.headers.clear();
            this._visitables.remove("headers");
        }
        if (headers != null) {
            for (GRPCHeaderMatch item : headers) {
                this.addToHeaders(item);
            }
        }
        return (A)this;
    }

    public boolean hasHeaders() {
        return this.headers != null && !this.headers.isEmpty();
    }

    public A addNewHeader(String name, String type, String value) {
        return this.addToHeaders(new GRPCHeaderMatch(name, type, value));
    }

    public HeadersNested<A> addNewHeader() {
        return new HeadersNested(-1, null);
    }

    public HeadersNested<A> addNewHeaderLike(GRPCHeaderMatch item) {
        return new HeadersNested(-1, item);
    }

    public HeadersNested<A> setNewHeaderLike(int index, GRPCHeaderMatch item) {
        return new HeadersNested(index, item);
    }

    public HeadersNested<A> editHeader(int index) {
        if (this.headers.size() <= index) {
            throw new RuntimeException("Can't edit headers. Index exceeds size.");
        }
        return this.setNewHeaderLike(index, this.buildHeader(index));
    }

    public HeadersNested<A> editFirstHeader() {
        if (this.headers.size() == 0) {
            throw new RuntimeException("Can't edit first headers. The list is empty.");
        }
        return this.setNewHeaderLike(0, this.buildHeader(0));
    }

    public HeadersNested<A> editLastHeader() {
        int index = this.headers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last headers. The list is empty.");
        }
        return this.setNewHeaderLike(index, this.buildHeader(index));
    }

    public HeadersNested<A> editMatchingHeader(Predicate<GRPCHeaderMatchBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.headers.size(); ++i) {
            if (!predicate.test(this.headers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching headers. No match found.");
        }
        return this.setNewHeaderLike(index, this.buildHeader(index));
    }

    public GRPCMethodMatch buildMethod() {
        return this.method != null ? this.method.build() : null;
    }

    public A withMethod(GRPCMethodMatch method) {
        this._visitables.get("method").remove(this.method);
        if (method != null) {
            this.method = new GRPCMethodMatchBuilder(method);
            this._visitables.get("method").add(this.method);
        } else {
            this.method = null;
            this._visitables.get("method").remove(this.method);
        }
        return (A)this;
    }

    public boolean hasMethod() {
        return this.method != null;
    }

    public A withNewMethod(String method, String service, String type) {
        return this.withMethod(new GRPCMethodMatch(method, service, type));
    }

    public MethodNested<A> withNewMethod() {
        return new MethodNested(null);
    }

    public MethodNested<A> withNewMethodLike(GRPCMethodMatch item) {
        return new MethodNested(item);
    }

    public MethodNested<A> editMethod() {
        return this.withNewMethodLike(Optional.ofNullable(this.buildMethod()).orElse(null));
    }

    public MethodNested<A> editOrNewMethod() {
        return this.withNewMethodLike(Optional.ofNullable(this.buildMethod()).orElse(new GRPCMethodMatchBuilder().build()));
    }

    public MethodNested<A> editOrNewMethodLike(GRPCMethodMatch item) {
        return this.withNewMethodLike(Optional.ofNullable(this.buildMethod()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GRPCRouteMatchFluent that = (GRPCRouteMatchFluent)o;
        if (!Objects.equals(this.headers, that.headers)) {
            return false;
        }
        if (!Objects.equals(this.method, that.method)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.headers, this.method, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.headers != null && !this.headers.isEmpty()) {
            sb.append("headers:");
            sb.append(this.headers + ",");
        }
        if (this.method != null) {
            sb.append("method:");
            sb.append(this.method + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MethodNested<N>
    extends GRPCMethodMatchFluent<MethodNested<N>>
    implements Nested<N> {
        GRPCMethodMatchBuilder builder;

        MethodNested(GRPCMethodMatch item) {
            this.builder = new GRPCMethodMatchBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)GRPCRouteMatchFluent.this.withMethod(this.builder.build());
        }

        public N endMethod() {
            return this.and();
        }
    }

    public class HeadersNested<N>
    extends GRPCHeaderMatchFluent<HeadersNested<N>>
    implements Nested<N> {
        GRPCHeaderMatchBuilder builder;
        int index;

        HeadersNested(int index, GRPCHeaderMatch item) {
            this.index = index;
            this.builder = new GRPCHeaderMatchBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)GRPCRouteMatchFluent.this.setToHeaders(this.index, this.builder.build());
        }

        public N endHeader() {
            return this.and();
        }
    }
}

