/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.DriverRequests;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.ResourceClaimParametersBuilder;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.ResourceClaimParametersReference;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonDeserialize(using=JsonDeserializer.None.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "driverRequests", "generatedFrom", "shareable"})
@Version(value="v1alpha2")
@Group(value="resource.k8s.io")
public class ResourceClaimParameters
implements Editable<ResourceClaimParametersBuilder>,
HasMetadata,
Namespaced {
    @JsonProperty(value="apiVersion")
    private String apiVersion = "resource.k8s.io/v1alpha2";
    @JsonProperty(value="driverRequests")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<DriverRequests> driverRequests = new ArrayList<DriverRequests>();
    @JsonProperty(value="generatedFrom")
    private ResourceClaimParametersReference generatedFrom;
    @JsonProperty(value="kind")
    private String kind = "ResourceClaimParameters";
    @JsonProperty(value="metadata")
    private ObjectMeta metadata;
    @JsonProperty(value="shareable")
    private Boolean shareable;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    public ResourceClaimParameters() {
    }

    public ResourceClaimParameters(String apiVersion, List<DriverRequests> driverRequests, ResourceClaimParametersReference generatedFrom, String kind, ObjectMeta metadata, Boolean shareable) {
        this.apiVersion = apiVersion;
        this.driverRequests = driverRequests;
        this.generatedFrom = generatedFrom;
        this.kind = kind;
        this.metadata = metadata;
        this.shareable = shareable;
    }

    @Override
    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    @JsonProperty(value="apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="driverRequests")
    public List<DriverRequests> getDriverRequests() {
        return this.driverRequests;
    }

    @JsonProperty(value="driverRequests")
    public void setDriverRequests(List<DriverRequests> driverRequests) {
        this.driverRequests = driverRequests;
    }

    @JsonProperty(value="generatedFrom")
    public ResourceClaimParametersReference getGeneratedFrom() {
        return this.generatedFrom;
    }

    @JsonProperty(value="generatedFrom")
    public void setGeneratedFrom(ResourceClaimParametersReference generatedFrom) {
        this.generatedFrom = generatedFrom;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @Override
    @JsonProperty(value="metadata")
    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="metadata")
    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="shareable")
    public Boolean getShareable() {
        return this.shareable;
    }

    @JsonProperty(value="shareable")
    public void setShareable(Boolean shareable) {
        this.shareable = shareable;
    }

    @Override
    @JsonIgnore
    public ResourceClaimParametersBuilder edit() {
        return new ResourceClaimParametersBuilder(this);
    }

    @JsonIgnore
    public ResourceClaimParametersBuilder toBuilder() {
        return this.edit();
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "ResourceClaimParameters(apiVersion=" + this.getApiVersion() + ", driverRequests=" + this.getDriverRequests() + ", generatedFrom=" + this.getGeneratedFrom() + ", kind=" + this.getKind() + ", metadata=" + this.getMetadata() + ", shareable=" + this.getShareable() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceClaimParameters)) {
            return false;
        }
        ResourceClaimParameters other = (ResourceClaimParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$shareable = this.getShareable();
        Boolean other$shareable = other.getShareable();
        if (this$shareable == null ? other$shareable != null : !((Object)this$shareable).equals(other$shareable)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        List<DriverRequests> this$driverRequests = this.getDriverRequests();
        List<DriverRequests> other$driverRequests = other.getDriverRequests();
        if (this$driverRequests == null ? other$driverRequests != null : !((Object)this$driverRequests).equals(other$driverRequests)) {
            return false;
        }
        ResourceClaimParametersReference this$generatedFrom = this.getGeneratedFrom();
        ResourceClaimParametersReference other$generatedFrom = other.getGeneratedFrom();
        if (this$generatedFrom == null ? other$generatedFrom != null : !((Object)this$generatedFrom).equals(other$generatedFrom)) {
            return false;
        }
        String this$kind = this.getKind();
        String other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        ObjectMeta this$metadata = this.getMetadata();
        ObjectMeta other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResourceClaimParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $shareable = this.getShareable();
        result = result * 59 + ($shareable == null ? 43 : ((Object)$shareable).hashCode());
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        List<DriverRequests> $driverRequests = this.getDriverRequests();
        result = result * 59 + ($driverRequests == null ? 43 : ((Object)$driverRequests).hashCode());
        ResourceClaimParametersReference $generatedFrom = this.getGeneratedFrom();
        result = result * 59 + ($generatedFrom == null ? 43 : ((Object)$generatedFrom).hashCode());
        String $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        ObjectMeta $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    @JsonIgnore
    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }
}

