/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.java.generator.nodes;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LiteralStringValueExpr;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import io.fabric8.java.generator.Config;
import io.fabric8.java.generator.nodes.AbstractJSONSchema2Pojo;
import io.fabric8.java.generator.nodes.GeneratorResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;

public class JEnum
extends AbstractJSONSchema2Pojo {
    private static final String VALUE = "value";
    private final String type;
    private final String underlyingType;
    private final Set<String> values;

    public JEnum(String type, String underlyingType, List<JsonNode> values, Config config, String description, boolean isNullable, JsonNode defaultValue) {
        super(config, description, isNullable, defaultValue, null);
        this.type = AbstractJSONSchema2Pojo.sanitizeString(type.substring(0, 1).toUpperCase() + type.substring(1));
        this.underlyingType = underlyingType;
        this.values = values.stream().map(JsonNode::asText).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public String getType() {
        return this.type;
    }

    private String sanitizeEnumEntry(String str) {
        String ret = str;
        if (this.config.isUppercaseEnums()) {
            ret = ret.toUpperCase(Locale.ROOT);
        }
        if (ret.isEmpty()) {
            return "_EMPTY";
        }
        return ret.replaceAll("[\\s|\\./]", "_");
    }

    @Override
    public GeneratorResult generateJava() {
        CompilationUnit cu = new CompilationUnit();
        EnumDeclaration en = cu.addEnum(this.type);
        en.addField(this.underlyingType, VALUE, new Modifier.Keyword[0]);
        ConstructorDeclaration cd = en.addConstructor(new Modifier.Keyword[0]);
        cd.addParameter(this.underlyingType, VALUE);
        cd.createBody();
        cd.setBody((BlockStmt)new BlockStmt().addStatement(new AssignExpr(new NameExpr("this.value"), new NameExpr(VALUE), AssignExpr.Operator.ASSIGN)));
        MethodDeclaration getValue = en.addMethod("getValue", Modifier.Keyword.PUBLIC);
        getValue.setType(this.underlyingType);
        getValue.setBody((BlockStmt)new BlockStmt().addStatement(new ReturnStmt(VALUE)));
        getValue.addAnnotation("com.fasterxml.jackson.annotation.JsonValue");
        for (String k : this.values) {
            String constantName;
            try {
                Integer.valueOf(k);
                constantName = "V_" + this.sanitizeEnumEntry(JEnum.sanitizeString(k));
            }
            catch (Exception e) {
                constantName = this.sanitizeEnumEntry(JEnum.sanitizeString(k));
            }
            String originalName = AbstractJSONSchema2Pojo.escapeQuotes(k);
            LiteralStringValueExpr valueArgument = new StringLiteralExpr(originalName);
            if (!this.underlyingType.equals("java.lang.String")) {
                valueArgument = this.underlyingType.equals("java.lang.Long") && !originalName.endsWith("L") ? new IntegerLiteralExpr(originalName + "L") : new IntegerLiteralExpr(originalName);
            }
            EnumConstantDeclaration decl = new EnumConstantDeclaration();
            decl.addAnnotation(new SingleMemberAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonProperty"), new StringLiteralExpr(originalName)));
            decl.setName(constantName);
            decl.addArgument(valueArgument);
            en.addEntry(decl);
        }
        return new GeneratorResult(new ArrayList<GeneratorResult.ClassResult>(), Collections.singletonList(new GeneratorResult.ClassResult(this.type, cu)));
    }
}

