/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.api.security.v1beta1;

import io.fabric8.istio.api.api.security.v1beta1.JWTRule;
import io.fabric8.istio.api.api.security.v1beta1.JWTRuleBuilder;
import io.fabric8.istio.api.api.security.v1beta1.JWTRuleFluent;
import io.fabric8.istio.api.api.security.v1beta1.RequestAuthentication;
import io.fabric8.istio.api.api.type.v1beta1.PolicyTargetReference;
import io.fabric8.istio.api.api.type.v1beta1.PolicyTargetReferenceBuilder;
import io.fabric8.istio.api.api.type.v1beta1.PolicyTargetReferenceFluent;
import io.fabric8.istio.api.api.type.v1beta1.WorkloadSelector;
import io.fabric8.istio.api.api.type.v1beta1.WorkloadSelectorBuilder;
import io.fabric8.istio.api.api.type.v1beta1.WorkloadSelectorFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class RequestAuthenticationFluent<A extends RequestAuthenticationFluent<A>>
extends BaseFluent<A> {
    private ArrayList<JWTRuleBuilder> jwtRules = new ArrayList();
    private WorkloadSelectorBuilder selector;
    private PolicyTargetReferenceBuilder targetRef;
    private ArrayList<PolicyTargetReferenceBuilder> targetRefs = new ArrayList();
    private Map<String, Object> additionalProperties;

    public RequestAuthenticationFluent() {
    }

    public RequestAuthenticationFluent(RequestAuthentication instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RequestAuthentication instance) {
        RequestAuthentication requestAuthentication = instance = instance != null ? instance : new RequestAuthentication();
        if (instance != null) {
            this.withJwtRules(instance.getJwtRules());
            this.withSelector(instance.getSelector());
            this.withTargetRef(instance.getTargetRef());
            this.withTargetRefs(instance.getTargetRefs());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToJwtRules(int index, JWTRule item) {
        if (this.jwtRules == null) {
            this.jwtRules = new ArrayList();
        }
        JWTRuleBuilder builder = new JWTRuleBuilder(item);
        if (index < 0 || index >= this.jwtRules.size()) {
            this._visitables.get((Object)"jwtRules").add(builder);
            this.jwtRules.add(builder);
        } else {
            this._visitables.get((Object)"jwtRules").add(builder);
            this.jwtRules.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToJwtRules(int index, JWTRule item) {
        if (this.jwtRules == null) {
            this.jwtRules = new ArrayList();
        }
        JWTRuleBuilder builder = new JWTRuleBuilder(item);
        if (index < 0 || index >= this.jwtRules.size()) {
            this._visitables.get((Object)"jwtRules").add(builder);
            this.jwtRules.add(builder);
        } else {
            this._visitables.get((Object)"jwtRules").add(builder);
            this.jwtRules.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToJwtRules(JWTRule ... items) {
        if (this.jwtRules == null) {
            this.jwtRules = new ArrayList();
        }
        for (JWTRule item : items) {
            JWTRuleBuilder builder = new JWTRuleBuilder(item);
            this._visitables.get((Object)"jwtRules").add(builder);
            this.jwtRules.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToJwtRules(Collection<JWTRule> items) {
        if (this.jwtRules == null) {
            this.jwtRules = new ArrayList();
        }
        for (JWTRule item : items) {
            JWTRuleBuilder builder = new JWTRuleBuilder(item);
            this._visitables.get((Object)"jwtRules").add(builder);
            this.jwtRules.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromJwtRules(JWTRule ... items) {
        if (this.jwtRules == null) {
            return (A)((Object)this);
        }
        for (JWTRule item : items) {
            JWTRuleBuilder builder = new JWTRuleBuilder(item);
            this._visitables.get((Object)"jwtRules").remove((Object)builder);
            this.jwtRules.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromJwtRules(Collection<JWTRule> items) {
        if (this.jwtRules == null) {
            return (A)((Object)this);
        }
        for (JWTRule item : items) {
            JWTRuleBuilder builder = new JWTRuleBuilder(item);
            this._visitables.get((Object)"jwtRules").remove((Object)builder);
            this.jwtRules.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromJwtRules(Predicate<JWTRuleBuilder> predicate) {
        if (this.jwtRules == null) {
            return (A)((Object)this);
        }
        Iterator<JWTRuleBuilder> each = this.jwtRules.iterator();
        List visitables = this._visitables.get((Object)"jwtRules");
        while (each.hasNext()) {
            JWTRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<JWTRule> buildJwtRules() {
        return this.jwtRules != null ? RequestAuthenticationFluent.build(this.jwtRules) : null;
    }

    public JWTRule buildJwtRule(int index) {
        return this.jwtRules.get(index).build();
    }

    public JWTRule buildFirstJwtRule() {
        return this.jwtRules.get(0).build();
    }

    public JWTRule buildLastJwtRule() {
        return this.jwtRules.get(this.jwtRules.size() - 1).build();
    }

    public JWTRule buildMatchingJwtRule(Predicate<JWTRuleBuilder> predicate) {
        for (JWTRuleBuilder item : this.jwtRules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingJwtRule(Predicate<JWTRuleBuilder> predicate) {
        for (JWTRuleBuilder item : this.jwtRules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withJwtRules(List<JWTRule> jwtRules) {
        if (this.jwtRules != null) {
            this._visitables.get((Object)"jwtRules").clear();
        }
        if (jwtRules != null) {
            this.jwtRules = new ArrayList();
            for (JWTRule item : jwtRules) {
                this.addToJwtRules(item);
            }
        } else {
            this.jwtRules = null;
        }
        return (A)((Object)this);
    }

    public A withJwtRules(JWTRule ... jwtRules) {
        if (this.jwtRules != null) {
            this.jwtRules.clear();
            this._visitables.remove((Object)"jwtRules");
        }
        if (jwtRules != null) {
            for (JWTRule item : jwtRules) {
                this.addToJwtRules(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasJwtRules() {
        return this.jwtRules != null && !this.jwtRules.isEmpty();
    }

    public JwtRulesNested<A> addNewJwtRule() {
        return new JwtRulesNested(-1, null);
    }

    public JwtRulesNested<A> addNewJwtRuleLike(JWTRule item) {
        return new JwtRulesNested(-1, item);
    }

    public JwtRulesNested<A> setNewJwtRuleLike(int index, JWTRule item) {
        return new JwtRulesNested(index, item);
    }

    public JwtRulesNested<A> editJwtRule(int index) {
        if (this.jwtRules.size() <= index) {
            throw new RuntimeException("Can't edit jwtRules. Index exceeds size.");
        }
        return this.setNewJwtRuleLike(index, this.buildJwtRule(index));
    }

    public JwtRulesNested<A> editFirstJwtRule() {
        if (this.jwtRules.size() == 0) {
            throw new RuntimeException("Can't edit first jwtRules. The list is empty.");
        }
        return this.setNewJwtRuleLike(0, this.buildJwtRule(0));
    }

    public JwtRulesNested<A> editLastJwtRule() {
        int index = this.jwtRules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last jwtRules. The list is empty.");
        }
        return this.setNewJwtRuleLike(index, this.buildJwtRule(index));
    }

    public JwtRulesNested<A> editMatchingJwtRule(Predicate<JWTRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.jwtRules.size(); ++i) {
            if (!predicate.test(this.jwtRules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching jwtRules. No match found.");
        }
        return this.setNewJwtRuleLike(index, this.buildJwtRule(index));
    }

    public WorkloadSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    public A withSelector(WorkloadSelector selector) {
        this._visitables.remove((Object)"selector");
        if (selector != null) {
            this.selector = new WorkloadSelectorBuilder(selector);
            this._visitables.get((Object)"selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get((Object)"selector").remove((Object)this.selector);
        }
        return (A)((Object)this);
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public SelectorNested<A> withNewSelector() {
        return new SelectorNested(null);
    }

    public SelectorNested<A> withNewSelectorLike(WorkloadSelector item) {
        return new SelectorNested(item);
    }

    public SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(null));
    }

    public SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(new WorkloadSelectorBuilder().build()));
    }

    public SelectorNested<A> editOrNewSelectorLike(WorkloadSelector item) {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(item));
    }

    public PolicyTargetReference buildTargetRef() {
        return this.targetRef != null ? this.targetRef.build() : null;
    }

    public A withTargetRef(PolicyTargetReference targetRef) {
        this._visitables.remove((Object)"targetRef");
        if (targetRef != null) {
            this.targetRef = new PolicyTargetReferenceBuilder(targetRef);
            this._visitables.get((Object)"targetRef").add(this.targetRef);
        } else {
            this.targetRef = null;
            this._visitables.get((Object)"targetRef").remove((Object)this.targetRef);
        }
        return (A)((Object)this);
    }

    public boolean hasTargetRef() {
        return this.targetRef != null;
    }

    public A withNewTargetRef(String group, String kind, String name, String namespace) {
        return this.withTargetRef(new PolicyTargetReference(group, kind, name, namespace));
    }

    public TargetRefNested<A> withNewTargetRef() {
        return new TargetRefNested(null);
    }

    public TargetRefNested<A> withNewTargetRefLike(PolicyTargetReference item) {
        return new TargetRefNested(item);
    }

    public TargetRefNested<A> editTargetRef() {
        return this.withNewTargetRefLike(Optional.ofNullable(this.buildTargetRef()).orElse(null));
    }

    public TargetRefNested<A> editOrNewTargetRef() {
        return this.withNewTargetRefLike(Optional.ofNullable(this.buildTargetRef()).orElse(new PolicyTargetReferenceBuilder().build()));
    }

    public TargetRefNested<A> editOrNewTargetRefLike(PolicyTargetReference item) {
        return this.withNewTargetRefLike(Optional.ofNullable(this.buildTargetRef()).orElse(item));
    }

    public A addToTargetRefs(int index, PolicyTargetReference item) {
        if (this.targetRefs == null) {
            this.targetRefs = new ArrayList();
        }
        PolicyTargetReferenceBuilder builder = new PolicyTargetReferenceBuilder(item);
        if (index < 0 || index >= this.targetRefs.size()) {
            this._visitables.get((Object)"targetRefs").add(builder);
            this.targetRefs.add(builder);
        } else {
            this._visitables.get((Object)"targetRefs").add(builder);
            this.targetRefs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToTargetRefs(int index, PolicyTargetReference item) {
        if (this.targetRefs == null) {
            this.targetRefs = new ArrayList();
        }
        PolicyTargetReferenceBuilder builder = new PolicyTargetReferenceBuilder(item);
        if (index < 0 || index >= this.targetRefs.size()) {
            this._visitables.get((Object)"targetRefs").add(builder);
            this.targetRefs.add(builder);
        } else {
            this._visitables.get((Object)"targetRefs").add(builder);
            this.targetRefs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToTargetRefs(PolicyTargetReference ... items) {
        if (this.targetRefs == null) {
            this.targetRefs = new ArrayList();
        }
        for (PolicyTargetReference item : items) {
            PolicyTargetReferenceBuilder builder = new PolicyTargetReferenceBuilder(item);
            this._visitables.get((Object)"targetRefs").add(builder);
            this.targetRefs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToTargetRefs(Collection<PolicyTargetReference> items) {
        if (this.targetRefs == null) {
            this.targetRefs = new ArrayList();
        }
        for (PolicyTargetReference item : items) {
            PolicyTargetReferenceBuilder builder = new PolicyTargetReferenceBuilder(item);
            this._visitables.get((Object)"targetRefs").add(builder);
            this.targetRefs.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTargetRefs(PolicyTargetReference ... items) {
        if (this.targetRefs == null) {
            return (A)((Object)this);
        }
        for (PolicyTargetReference item : items) {
            PolicyTargetReferenceBuilder builder = new PolicyTargetReferenceBuilder(item);
            this._visitables.get((Object)"targetRefs").remove((Object)builder);
            this.targetRefs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTargetRefs(Collection<PolicyTargetReference> items) {
        if (this.targetRefs == null) {
            return (A)((Object)this);
        }
        for (PolicyTargetReference item : items) {
            PolicyTargetReferenceBuilder builder = new PolicyTargetReferenceBuilder(item);
            this._visitables.get((Object)"targetRefs").remove((Object)builder);
            this.targetRefs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTargetRefs(Predicate<PolicyTargetReferenceBuilder> predicate) {
        if (this.targetRefs == null) {
            return (A)((Object)this);
        }
        Iterator<PolicyTargetReferenceBuilder> each = this.targetRefs.iterator();
        List visitables = this._visitables.get((Object)"targetRefs");
        while (each.hasNext()) {
            PolicyTargetReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<PolicyTargetReference> buildTargetRefs() {
        return this.targetRefs != null ? RequestAuthenticationFluent.build(this.targetRefs) : null;
    }

    public PolicyTargetReference buildTargetRef(int index) {
        return this.targetRefs.get(index).build();
    }

    public PolicyTargetReference buildFirstTargetRef() {
        return this.targetRefs.get(0).build();
    }

    public PolicyTargetReference buildLastTargetRef() {
        return this.targetRefs.get(this.targetRefs.size() - 1).build();
    }

    public PolicyTargetReference buildMatchingTargetRef(Predicate<PolicyTargetReferenceBuilder> predicate) {
        for (PolicyTargetReferenceBuilder item : this.targetRefs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTargetRef(Predicate<PolicyTargetReferenceBuilder> predicate) {
        for (PolicyTargetReferenceBuilder item : this.targetRefs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTargetRefs(List<PolicyTargetReference> targetRefs) {
        if (this.targetRefs != null) {
            this._visitables.get((Object)"targetRefs").clear();
        }
        if (targetRefs != null) {
            this.targetRefs = new ArrayList();
            for (PolicyTargetReference item : targetRefs) {
                this.addToTargetRefs(item);
            }
        } else {
            this.targetRefs = null;
        }
        return (A)((Object)this);
    }

    public A withTargetRefs(PolicyTargetReference ... targetRefs) {
        if (this.targetRefs != null) {
            this.targetRefs.clear();
            this._visitables.remove((Object)"targetRefs");
        }
        if (targetRefs != null) {
            for (PolicyTargetReference item : targetRefs) {
                this.addToTargetRefs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTargetRefs() {
        return this.targetRefs != null && !this.targetRefs.isEmpty();
    }

    public A addNewTargetRef(String group, String kind, String name, String namespace) {
        return this.addToTargetRefs(new PolicyTargetReference(group, kind, name, namespace));
    }

    public TargetRefsNested<A> addNewTargetRef() {
        return new TargetRefsNested(-1, null);
    }

    public TargetRefsNested<A> addNewTargetRefLike(PolicyTargetReference item) {
        return new TargetRefsNested(-1, item);
    }

    public TargetRefsNested<A> setNewTargetRefLike(int index, PolicyTargetReference item) {
        return new TargetRefsNested(index, item);
    }

    public TargetRefsNested<A> editTargetRef(int index) {
        if (this.targetRefs.size() <= index) {
            throw new RuntimeException("Can't edit targetRefs. Index exceeds size.");
        }
        return this.setNewTargetRefLike(index, this.buildTargetRef(index));
    }

    public TargetRefsNested<A> editFirstTargetRef() {
        if (this.targetRefs.size() == 0) {
            throw new RuntimeException("Can't edit first targetRefs. The list is empty.");
        }
        return this.setNewTargetRefLike(0, this.buildTargetRef(0));
    }

    public TargetRefsNested<A> editLastTargetRef() {
        int index = this.targetRefs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last targetRefs. The list is empty.");
        }
        return this.setNewTargetRefLike(index, this.buildTargetRef(index));
    }

    public TargetRefsNested<A> editMatchingTargetRef(Predicate<PolicyTargetReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.targetRefs.size(); ++i) {
            if (!predicate.test(this.targetRefs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching targetRefs. No match found.");
        }
        return this.setNewTargetRefLike(index, this.buildTargetRef(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RequestAuthenticationFluent that = (RequestAuthenticationFluent)((Object)o);
        if (!Objects.equals(this.jwtRules, that.jwtRules)) {
            return false;
        }
        if (!Objects.equals((Object)this.selector, (Object)that.selector)) {
            return false;
        }
        if (!Objects.equals((Object)this.targetRef, (Object)that.targetRef)) {
            return false;
        }
        if (!Objects.equals(this.targetRefs, that.targetRefs)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jwtRules, this.selector, this.targetRef, this.targetRefs, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jwtRules != null && !this.jwtRules.isEmpty()) {
            sb.append("jwtRules:");
            sb.append(String.valueOf(this.jwtRules) + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(String.valueOf((Object)this.selector) + ",");
        }
        if (this.targetRef != null) {
            sb.append("targetRef:");
            sb.append(String.valueOf((Object)this.targetRef) + ",");
        }
        if (this.targetRefs != null && !this.targetRefs.isEmpty()) {
            sb.append("targetRefs:");
            sb.append(String.valueOf(this.targetRefs) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TargetRefsNested<N>
    extends PolicyTargetReferenceFluent<TargetRefsNested<N>>
    implements Nested<N> {
        PolicyTargetReferenceBuilder builder;
        int index;

        TargetRefsNested(int index, PolicyTargetReference item) {
            this.index = index;
            this.builder = new PolicyTargetReferenceBuilder(this, item);
        }

        public N and() {
            return (N)RequestAuthenticationFluent.this.setToTargetRefs(this.index, this.builder.build());
        }

        public N endTargetRef() {
            return this.and();
        }
    }

    public class TargetRefNested<N>
    extends PolicyTargetReferenceFluent<TargetRefNested<N>>
    implements Nested<N> {
        PolicyTargetReferenceBuilder builder;

        TargetRefNested(PolicyTargetReference item) {
            this.builder = new PolicyTargetReferenceBuilder(this, item);
        }

        public N and() {
            return (N)RequestAuthenticationFluent.this.withTargetRef(this.builder.build());
        }

        public N endTargetRef() {
            return this.and();
        }
    }

    public class SelectorNested<N>
    extends WorkloadSelectorFluent<SelectorNested<N>>
    implements Nested<N> {
        WorkloadSelectorBuilder builder;

        SelectorNested(WorkloadSelector item) {
            this.builder = new WorkloadSelectorBuilder(this, item);
        }

        public N and() {
            return (N)RequestAuthenticationFluent.this.withSelector(this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }

    public class JwtRulesNested<N>
    extends JWTRuleFluent<JwtRulesNested<N>>
    implements Nested<N> {
        JWTRuleBuilder builder;
        int index;

        JwtRulesNested(int index, JWTRule item) {
            this.index = index;
            this.builder = new JWTRuleBuilder(this, item);
        }

        public N and() {
            return (N)RequestAuthenticationFluent.this.setToJwtRules(this.index, this.builder.build());
        }

        public N endJwtRule() {
            return this.and();
        }
    }
}

