/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.api.security.v1beta1;

import io.fabric8.istio.api.api.security.v1beta1.Condition;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ConditionFluent<A extends ConditionFluent<A>>
extends BaseFluent<A> {
    private String key;
    private List<String> notValues = new ArrayList<String>();
    private List<String> values = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public ConditionFluent() {
    }

    public ConditionFluent(Condition instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Condition instance) {
        Condition condition = instance = instance != null ? instance : new Condition();
        if (instance != null) {
            this.withKey(instance.getKey());
            this.withNotValues(instance.getNotValues());
            this.withValues(instance.getValues());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getKey() {
        return this.key;
    }

    public A withKey(String key) {
        this.key = key;
        return (A)((Object)this);
    }

    public boolean hasKey() {
        return this.key != null;
    }

    public A addToNotValues(int index, String item) {
        if (this.notValues == null) {
            this.notValues = new ArrayList<String>();
        }
        this.notValues.add(index, item);
        return (A)((Object)this);
    }

    public A setToNotValues(int index, String item) {
        if (this.notValues == null) {
            this.notValues = new ArrayList<String>();
        }
        this.notValues.set(index, item);
        return (A)((Object)this);
    }

    public A addToNotValues(String ... items) {
        if (this.notValues == null) {
            this.notValues = new ArrayList<String>();
        }
        for (String item : items) {
            this.notValues.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToNotValues(Collection<String> items) {
        if (this.notValues == null) {
            this.notValues = new ArrayList<String>();
        }
        for (String item : items) {
            this.notValues.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromNotValues(String ... items) {
        if (this.notValues == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.notValues.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromNotValues(Collection<String> items) {
        if (this.notValues == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.notValues.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getNotValues() {
        return this.notValues;
    }

    public String getNotValue(int index) {
        return this.notValues.get(index);
    }

    public String getFirstNotValue() {
        return this.notValues.get(0);
    }

    public String getLastNotValue() {
        return this.notValues.get(this.notValues.size() - 1);
    }

    public String getMatchingNotValue(Predicate<String> predicate) {
        for (String item : this.notValues) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingNotValue(Predicate<String> predicate) {
        for (String item : this.notValues) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNotValues(List<String> notValues) {
        if (notValues != null) {
            this.notValues = new ArrayList<String>();
            for (String item : notValues) {
                this.addToNotValues(item);
            }
        } else {
            this.notValues = null;
        }
        return (A)((Object)this);
    }

    public A withNotValues(String ... notValues) {
        if (this.notValues != null) {
            this.notValues.clear();
            this._visitables.remove((Object)"notValues");
        }
        if (notValues != null) {
            for (String item : notValues) {
                this.addToNotValues(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasNotValues() {
        return this.notValues != null && !this.notValues.isEmpty();
    }

    public A addToValues(int index, String item) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(index, item);
        return (A)((Object)this);
    }

    public A setToValues(int index, String item) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.set(index, item);
        return (A)((Object)this);
    }

    public A addToValues(String ... items) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        for (String item : items) {
            this.values.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToValues(Collection<String> items) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        for (String item : items) {
            this.values.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromValues(String ... items) {
        if (this.values == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.values.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromValues(Collection<String> items) {
        if (this.values == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.values.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getValues() {
        return this.values;
    }

    public String getValue(int index) {
        return this.values.get(index);
    }

    public String getFirstValue() {
        return this.values.get(0);
    }

    public String getLastValue() {
        return this.values.get(this.values.size() - 1);
    }

    public String getMatchingValue(Predicate<String> predicate) {
        for (String item : this.values) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingValue(Predicate<String> predicate) {
        for (String item : this.values) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withValues(List<String> values) {
        if (values != null) {
            this.values = new ArrayList<String>();
            for (String item : values) {
                this.addToValues(item);
            }
        } else {
            this.values = null;
        }
        return (A)((Object)this);
    }

    public A withValues(String ... values) {
        if (this.values != null) {
            this.values.clear();
            this._visitables.remove((Object)"values");
        }
        if (values != null) {
            for (String item : values) {
                this.addToValues(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasValues() {
        return this.values != null && !this.values.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConditionFluent that = (ConditionFluent)((Object)o);
        if (!Objects.equals(this.key, that.key)) {
            return false;
        }
        if (!Objects.equals(this.notValues, that.notValues)) {
            return false;
        }
        if (!Objects.equals(this.values, that.values)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.notValues, this.values, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.key != null) {
            sb.append("key:");
            sb.append(this.key + ",");
        }
        if (this.notValues != null && !this.notValues.isEmpty()) {
            sb.append("notValues:");
            sb.append(String.valueOf(this.notValues) + ",");
        }
        if (this.values != null && !this.values.isEmpty()) {
            sb.append("values:");
            sb.append(String.valueOf(this.values) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

