/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.api.analysis.v1alpha1;

import io.fabric8.istio.api.api.analysis.v1alpha1.AnalysisMessageBase;
import io.fabric8.istio.api.api.analysis.v1alpha1.AnalysisMessageBaseBuilder;
import io.fabric8.istio.api.api.analysis.v1alpha1.AnalysisMessageBaseFluent;
import io.fabric8.istio.api.api.analysis.v1alpha1.GenericAnalysisMessage;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class GenericAnalysisMessageFluent<A extends GenericAnalysisMessageFluent<A>>
extends BaseFluent<A> {
    private Object args;
    private AnalysisMessageBaseBuilder messageBase;
    private List<String> resourcePaths = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public GenericAnalysisMessageFluent() {
    }

    public GenericAnalysisMessageFluent(GenericAnalysisMessage instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(GenericAnalysisMessage instance) {
        GenericAnalysisMessage genericAnalysisMessage = instance = instance != null ? instance : new GenericAnalysisMessage();
        if (instance != null) {
            this.withArgs(instance.getArgs());
            this.withMessageBase(instance.getMessageBase());
            this.withResourcePaths(instance.getResourcePaths());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Object getArgs() {
        return this.args;
    }

    public A withArgs(Object args) {
        this.args = args;
        return (A)((Object)this);
    }

    public boolean hasArgs() {
        return this.args != null;
    }

    public AnalysisMessageBase buildMessageBase() {
        return this.messageBase != null ? this.messageBase.build() : null;
    }

    public A withMessageBase(AnalysisMessageBase messageBase) {
        this._visitables.remove((Object)"messageBase");
        if (messageBase != null) {
            this.messageBase = new AnalysisMessageBaseBuilder(messageBase);
            this._visitables.get((Object)"messageBase").add(this.messageBase);
        } else {
            this.messageBase = null;
            this._visitables.get((Object)"messageBase").remove((Object)this.messageBase);
        }
        return (A)((Object)this);
    }

    public boolean hasMessageBase() {
        return this.messageBase != null;
    }

    public MessageBaseNested<A> withNewMessageBase() {
        return new MessageBaseNested(null);
    }

    public MessageBaseNested<A> withNewMessageBaseLike(AnalysisMessageBase item) {
        return new MessageBaseNested(item);
    }

    public MessageBaseNested<A> editMessageBase() {
        return this.withNewMessageBaseLike(Optional.ofNullable(this.buildMessageBase()).orElse(null));
    }

    public MessageBaseNested<A> editOrNewMessageBase() {
        return this.withNewMessageBaseLike(Optional.ofNullable(this.buildMessageBase()).orElse(new AnalysisMessageBaseBuilder().build()));
    }

    public MessageBaseNested<A> editOrNewMessageBaseLike(AnalysisMessageBase item) {
        return this.withNewMessageBaseLike(Optional.ofNullable(this.buildMessageBase()).orElse(item));
    }

    public A addToResourcePaths(int index, String item) {
        if (this.resourcePaths == null) {
            this.resourcePaths = new ArrayList<String>();
        }
        this.resourcePaths.add(index, item);
        return (A)((Object)this);
    }

    public A setToResourcePaths(int index, String item) {
        if (this.resourcePaths == null) {
            this.resourcePaths = new ArrayList<String>();
        }
        this.resourcePaths.set(index, item);
        return (A)((Object)this);
    }

    public A addToResourcePaths(String ... items) {
        if (this.resourcePaths == null) {
            this.resourcePaths = new ArrayList<String>();
        }
        for (String item : items) {
            this.resourcePaths.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToResourcePaths(Collection<String> items) {
        if (this.resourcePaths == null) {
            this.resourcePaths = new ArrayList<String>();
        }
        for (String item : items) {
            this.resourcePaths.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromResourcePaths(String ... items) {
        if (this.resourcePaths == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.resourcePaths.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromResourcePaths(Collection<String> items) {
        if (this.resourcePaths == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.resourcePaths.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getResourcePaths() {
        return this.resourcePaths;
    }

    public String getResourcePath(int index) {
        return this.resourcePaths.get(index);
    }

    public String getFirstResourcePath() {
        return this.resourcePaths.get(0);
    }

    public String getLastResourcePath() {
        return this.resourcePaths.get(this.resourcePaths.size() - 1);
    }

    public String getMatchingResourcePath(Predicate<String> predicate) {
        for (String item : this.resourcePaths) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingResourcePath(Predicate<String> predicate) {
        for (String item : this.resourcePaths) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResourcePaths(List<String> resourcePaths) {
        if (resourcePaths != null) {
            this.resourcePaths = new ArrayList<String>();
            for (String item : resourcePaths) {
                this.addToResourcePaths(item);
            }
        } else {
            this.resourcePaths = null;
        }
        return (A)((Object)this);
    }

    public A withResourcePaths(String ... resourcePaths) {
        if (this.resourcePaths != null) {
            this.resourcePaths.clear();
            this._visitables.remove((Object)"resourcePaths");
        }
        if (resourcePaths != null) {
            for (String item : resourcePaths) {
                this.addToResourcePaths(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasResourcePaths() {
        return this.resourcePaths != null && !this.resourcePaths.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GenericAnalysisMessageFluent that = (GenericAnalysisMessageFluent)((Object)o);
        if (!Objects.equals(this.args, that.args)) {
            return false;
        }
        if (!Objects.equals((Object)this.messageBase, (Object)that.messageBase)) {
            return false;
        }
        if (!Objects.equals(this.resourcePaths, that.resourcePaths)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.args, this.messageBase, this.resourcePaths, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.args != null) {
            sb.append("args:");
            sb.append(String.valueOf(this.args) + ",");
        }
        if (this.messageBase != null) {
            sb.append("messageBase:");
            sb.append(String.valueOf((Object)this.messageBase) + ",");
        }
        if (this.resourcePaths != null && !this.resourcePaths.isEmpty()) {
            sb.append("resourcePaths:");
            sb.append(String.valueOf(this.resourcePaths) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MessageBaseNested<N>
    extends AnalysisMessageBaseFluent<MessageBaseNested<N>>
    implements Nested<N> {
        AnalysisMessageBaseBuilder builder;

        MessageBaseNested(AnalysisMessageBase item) {
            this.builder = new AnalysisMessageBaseBuilder(this, item);
        }

        public N and() {
            return (N)GenericAnalysisMessageFluent.this.withMessageBase(this.builder.build());
        }

        public N endMessageBase() {
            return this.and();
        }
    }
}

