/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.examples.v1beta1;

import io.fabric8.istio.api.examples.v1beta1.ClientFactory;
import io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequestFluent;
import io.fabric8.istio.api.networking.v1beta1.HTTPRouteDestinationFluent;
import io.fabric8.istio.api.networking.v1beta1.HTTPRouteFluent;
import io.fabric8.istio.api.networking.v1beta1.VirtualServiceBuilder;
import io.fabric8.istio.api.networking.v1beta1.VirtualServiceFluent;
import io.fabric8.istio.api.networking.v1beta1.VirtualServiceList;
import io.fabric8.istio.api.networking.v1beta1.VirtualServiceSpecFluent;
import io.fabric8.istio.client.IstioClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;

public class VirtualServiceExample {
    private static final String NAMESPACE = "test";

    public static void main(String[] args) {
        try {
            IstioClient client = ClientFactory.newClient(args);
            VirtualServiceExample.createResource(client);
            System.exit(0);
        }
        catch (KubernetesClientException ex) {
            System.err.println("Failed with " + ex.getMessage());
            System.exit(1);
        }
    }

    public static void createResource(IstioClient client) {
        System.out.println("Creating a virtual service");
        String reviewsHost = "reviews.prod.svc.cluster.local";
        ((NonNamespaceOperation)client.v1beta1().virtualServices().inNamespace(NAMESPACE)).create((Object)((VirtualServiceBuilder)((VirtualServiceFluent.SpecNested)((VirtualServiceSpecFluent.HttpNested)((HTTPRouteFluent.RouteNested)((HTTPRouteDestinationFluent.DestinationNested)((HTTPRouteDestinationFluent.DestinationNested)((VirtualServiceSpecFluent.HttpNested)((VirtualServiceFluent.SpecNested)((VirtualServiceSpecFluent.HttpNested)((HTTPRouteFluent.RouteNested)((HTTPRouteDestinationFluent.DestinationNested)((HTTPRouteDestinationFluent.DestinationNested)((VirtualServiceSpecFluent.HttpNested)((HTTPRouteFluent.RewriteNested)((VirtualServiceSpecFluent.HttpNested)((HTTPRouteFluent.MatchNested)((HTTPMatchRequestFluent.UriNested)((VirtualServiceSpecFluent.HttpNested)((HTTPRouteFluent.MatchNested)((HTTPMatchRequestFluent.UriNested)((VirtualServiceSpecFluent.HttpNested)((VirtualServiceFluent.SpecNested)((VirtualServiceBuilder)((VirtualServiceFluent.MetadataNested)new VirtualServiceBuilder().withNewMetadata().withName("reviews-route")).endMetadata()).withNewSpec().addToHosts(new String[]{"reviews.prod.svc.cluster.local"})).addNewHttp().withName("reviews-v2-routes")).addNewMatch().withNewUri().withNewStringMatchPrefixType("/wpcatalog")).endUri()).endMatch()).addNewMatch().withNewUri().withNewStringMatchPrefixType("/consumercatalog")).endUri()).endMatch()).withNewRewrite().withUri("/newcatalog")).endRewrite()).addNewRoute().withNewDestination().withHost("reviews.prod.svc.cluster.local")).withSubset("v2")).endDestination()).endRoute()).endHttp()).addNewHttp().withName("reviews-v2-routes")).addNewRoute().withNewDestination().withHost("reviews.prod.svc.cluster.local")).withSubset("v1")).endDestination()).endRoute()).endHttp()).endSpec()).build());
        System.out.println("Listing Virtual Service Instances:");
        VirtualServiceList list = (VirtualServiceList)((NonNamespaceOperation)client.v1beta1().virtualServices().inNamespace(NAMESPACE)).list();
        list.getItems().forEach(b -> System.out.println(b.getMetadata().getName()));
        System.out.println("Done");
    }
}

