/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.examples.v1beta1;

import io.fabric8.istio.api.examples.v1beta1.ClientFactory;
import io.fabric8.istio.api.security.v1beta1.AuthorizationPolicyAction;
import io.fabric8.istio.api.security.v1beta1.AuthorizationPolicyBuilder;
import io.fabric8.istio.api.security.v1beta1.AuthorizationPolicyFluent;
import io.fabric8.istio.api.security.v1beta1.AuthorizationPolicyList;
import io.fabric8.istio.api.security.v1beta1.Condition;
import io.fabric8.istio.api.security.v1beta1.ConditionBuilder;
import io.fabric8.istio.api.security.v1beta1.OperationBuilder;
import io.fabric8.istio.api.security.v1beta1.Rule;
import io.fabric8.istio.api.security.v1beta1.RuleBuilder;
import io.fabric8.istio.api.security.v1beta1.RuleFrom;
import io.fabric8.istio.api.security.v1beta1.RuleFromBuilder;
import io.fabric8.istio.api.security.v1beta1.RuleTo;
import io.fabric8.istio.api.security.v1beta1.RuleToBuilder;
import io.fabric8.istio.api.security.v1beta1.SourceBuilder;
import io.fabric8.istio.api.type.v1beta1.WorkloadSelectorBuilder;
import io.fabric8.istio.client.IstioClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.util.Collections;

public class AuthorizationPolicyExample {
    private static final String NAMESPACE = "test";

    public static void main(String[] args) {
        try {
            IstioClient client = ClientFactory.newClient(args);
            AuthorizationPolicyExample.createResource(client);
            System.exit(0);
        }
        catch (KubernetesClientException ex) {
            System.err.println("Failed with " + ex.getMessage());
            System.exit(1);
        }
    }

    public static void createResource(IstioClient client) {
        System.out.println("Creating a AuthorizationPolicy entry");
        ((NonNamespaceOperation)client.v1beta1().authorizationPolicies().inNamespace(NAMESPACE)).create((Object)((AuthorizationPolicyBuilder)((AuthorizationPolicyFluent.SpecNested)((AuthorizationPolicyFluent.SpecNested)((AuthorizationPolicyFluent.SpecNested)((AuthorizationPolicyBuilder)((AuthorizationPolicyFluent.MetadataNested)new AuthorizationPolicyBuilder().withNewMetadata().withName("httpbin")).endMetadata()).withNewSpec().withSelector(((WorkloadSelectorBuilder)new WorkloadSelectorBuilder().withMatchLabels(Collections.singletonMap("app", "httpbin"))).build())).withAction(AuthorizationPolicyAction.DENY)).withRules(new Rule[]{((RuleBuilder)((RuleBuilder)((RuleBuilder)new RuleBuilder().withFrom(new RuleFrom[]{((RuleFromBuilder)new RuleFromBuilder().withSource(((SourceBuilder)new SourceBuilder().withPrincipals(new String[]{"cluster.local/ns/default/sa/sleep"})).build())).build(), ((RuleFromBuilder)new RuleFromBuilder().withSource(((SourceBuilder)new SourceBuilder().withNamespaces(new String[]{"dev"})).build())).build()})).withTo(new RuleTo[]{((RuleToBuilder)new RuleToBuilder().withOperation(((OperationBuilder)new OperationBuilder().withMethods(new String[]{"GET"})).build())).build()})).withWhen(new Condition[]{((ConditionBuilder)((ConditionBuilder)new ConditionBuilder().withKey("request.auth.claims[iss]")).withValues(new String[]{"https://accounts.google.com"})).build()})).build()})).endSpec()).build());
        System.out.println("Listing AuthorizationPolicy instances:");
        AuthorizationPolicyList list = (AuthorizationPolicyList)((NonNamespaceOperation)client.v1beta1().authorizationPolicies().inNamespace(NAMESPACE)).list();
        list.getItems().forEach(b -> System.out.println(b.getMetadata().getName()));
        System.out.println("Done");
    }
}

