/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.examples.v1beta1;

import io.fabric8.istio.api.examples.v1beta1.ClientFactory;
import io.fabric8.istio.api.networking.v1beta1.Port;
import io.fabric8.istio.api.networking.v1beta1.PortBuilder;
import io.fabric8.istio.api.networking.v1beta1.ServiceEntryBuilder;
import io.fabric8.istio.api.networking.v1beta1.ServiceEntryFluent;
import io.fabric8.istio.api.networking.v1beta1.ServiceEntryList;
import io.fabric8.istio.api.networking.v1beta1.ServiceEntryLocation;
import io.fabric8.istio.client.IstioClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;

public class ServiceEntryExample {
    private static final String NAMESPACE = "test";

    public static void main(String[] args) {
        try {
            IstioClient client = ClientFactory.newClient(args);
            ServiceEntryExample.createResource(client);
            System.exit(0);
        }
        catch (KubernetesClientException ex) {
            System.err.println("Failed with " + ex.getMessage());
            System.exit(1);
        }
    }

    public static void createResource(IstioClient client) {
        System.out.println("Creating a service entry");
        ((NonNamespaceOperation)client.v1beta1().serviceEntries().inNamespace(NAMESPACE)).create((Object)((ServiceEntryBuilder)((ServiceEntryFluent.SpecNested)((ServiceEntryFluent.SpecNested)((ServiceEntryFluent.SpecNested)((ServiceEntryBuilder)((ServiceEntryFluent.MetadataNested)new ServiceEntryBuilder().withNewMetadata().withName("external-svc-https")).endMetadata()).withNewSpec().withHosts(new String[]{"api.dropboxapi.com", "www.googleapis.com"})).withLocation(ServiceEntryLocation.MESH_INTERNAL)).withPorts(new Port[]{((PortBuilder)((PortBuilder)((PortBuilder)new PortBuilder().withName("https")).withProtocol("TLS")).withNumber(Integer.valueOf(443))).build()})).endSpec()).build());
        System.out.println("Listing Virtual Service Instances:");
        ServiceEntryList list = (ServiceEntryList)((NonNamespaceOperation)client.v1beta1().serviceEntries().inNamespace(NAMESPACE)).list();
        list.getItems().forEach(b -> System.out.println(b.getMetadata().getName()));
        System.out.println("Done");
    }
}

