/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.servlet.support;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Header;

public final class ProxySupport {
    public static final String JSESSIONID = "JSESSIONID";
    private static final Pattern PATH_AND_DOMAIN_PATTERN = Pattern.compile("(?:;\\s*([pP]ath|[dD]omain)=([^;\\s]+))");

    private ProxySupport() {
    }

    public static boolean isHopByHopHeader(String header) {
        return header.equalsIgnoreCase("Connection") || header.equalsIgnoreCase("Keep-Alive") || header.equalsIgnoreCase("Proxy-Authentication") || header.equalsIgnoreCase("Proxy-Authorization") || header.equalsIgnoreCase("TE") || header.equalsIgnoreCase("Trailers") || header.equalsIgnoreCase("Transfer-Encoding") || header.equalsIgnoreCase("Upgrade");
    }

    public static String replaceCookieAttributes(String header, String path, String domain) {
        Matcher m = PATH_AND_DOMAIN_PATTERN.matcher(header);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String name = m.group(1);
            if ("domain".equalsIgnoreCase(name)) {
                ProxySupport.appendReplacement(m, sb, name, domain);
                continue;
            }
            if (!"path".equalsIgnoreCase(name)) continue;
            ProxySupport.appendReplacement(m, sb, name, path);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static void appendReplacement(Matcher m, StringBuffer sb, String name, String value) {
        m.appendReplacement(sb, ';' + name + '=' + (value == null ? m.group(2) : value));
    }

    public static boolean isSetCookieHeader(Header header) {
        return header.getName().equalsIgnoreCase("Set-Cookie");
    }
}

