/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.fabric.haproxy;

import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.gateway.fabric.haproxy.FabricHaproxyGateway;
import io.fabric8.gateway.fabric.support.http.HttpMappingRuleBase;
import io.fabric8.gateway.fabric.support.http.HttpMappingZooKeeperTreeCache;
import io.fabric8.gateway.handlers.http.HttpMappingRule;
import io.fabric8.gateway.loadbalancer.LoadBalancer;
import io.fabric8.gateway.loadbalancer.LoadBalancers;
import io.fabric8.internal.Objects;
import io.fabric8.zookeeper.internal.SimplePathTemplate;
import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="io.fabric8.gateway.haproxy.mapping", immediate=true, metatype=true, policy=ConfigurationPolicy.REQUIRE, label="Fabric8 HAProxy HTTP Mapping Rule", description="Provides a mapping between part of the fabric cluster and a HTTP via HAProxy")
public class HttpMappingRuleConfiguration
extends AbstractComponent {
    private static final transient Logger LOG = LoggerFactory.getLogger(HttpMappingRuleConfiguration.class);
    @Reference
    private Configurer configurer;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, bind="setGateway", unbind="unsetGateway")
    private FabricHaproxyGateway gateway;
    @Property(name="zooKeeperPath", value={"/fabric/registry/clusters/webapps"}, label="ZooKeeper path", description="The path in ZooKeeper which is monitored to discover the available web services or web applications")
    private String zooKeeperPath;
    @Property(name="uriTemplate", value={"{contextPath}/"}, label="URI template", description="The URI template mapping the URI to the underlying service implementation.\nThis can use a number of URI template values such as 'contextPath', 'version', 'serviceName'")
    private String uriTemplate;
    @Property(name="enabledVersion", label="Enable version", description="Specify the exact profile version to expose; if none is specified then the gateways current profile version is used.\nIf a {version} URI template is used then all versions are exposed.")
    private String enabledVersion;
    @Property(name="reverseHeaders", boolValue={true}, label="Reverse headers", description="If enabled then the URL in the Location, Content-Location and URI headers from the proxied HTTP responses are rewritten from the back end service URL to match the front end URL on the gateway.\nThis is equivalent to the ProxyPassReverse directive in mod_proxy.")
    private boolean reverseHeaders = true;
    @Property(name="loadBalancerType", value={"roundrobin"}, options={@PropertyOption(name="random", value="Random"), @PropertyOption(name="roundrobin", value="Round Robin"), @PropertyOption(name="sticky", value="Sticky")}, label="Load Balancer", description="The kind of load balancing strategy used")
    private String loadBalancerType;
    @Property(name="stickyLoadBalancerCacheSize", intValue={10000}, label="Sticky Load Balancer Cache Size", description="The number of unique client keys to cache for the sticky load balancer (using an LRU caching algorithm)")
    private int stickyLoadBalancerCacheSize = 10000;
    private HttpMappingZooKeeperTreeCache mappingTree;
    private HttpMappingRuleBase httpMappingRuleBase;

    public String toString() {
        return "HttpMappingRuleConfiguration{zooKeeperPath='" + this.zooKeeperPath + '\'' + ", uriTemplate='" + this.uriTemplate + '\'' + ", enabledVersion='" + this.enabledVersion + '\'' + '}';
    }

    @Activate
    void activate(Map<String, ?> configuration) throws Exception {
        this.activateComponent();
        this.updateConfiguration(configuration);
    }

    @Modified
    void modified(Map<String, ?> configuration) throws Exception {
        this.deactivateInternal();
        this.updateConfiguration(configuration);
    }

    protected void updateConfiguration(Map<String, ?> configuration) throws Exception {
        this.configurer.configure(configuration, (Object)this, new String[0]);
        String zkPath = this.getZooKeeperPath();
        Objects.notNull((Object)((Object)this.getGateway()), (String)"gateway");
        Objects.notNull((Object)zkPath, (String)"zooKeeperPath");
        Objects.notNull((Object)this.getUriTemplate(), (String)"uriTemplate");
        LoadBalancer loadBalancer = LoadBalancers.createLoadBalancer((String)this.loadBalancerType, (int)this.stickyLoadBalancerCacheSize);
        LOG.info("activating http mapping ZooKeeper path: " + zkPath + " with URI template: " + this.uriTemplate + " enabledVersion: " + this.enabledVersion + " with load balancer: " + loadBalancer);
        if (this.httpMappingRuleBase != null) {
            this.gateway.removeMappingRuleConfiguration((HttpMappingRule)this.httpMappingRuleBase);
        }
        this.httpMappingRuleBase = new HttpMappingRuleBase(new SimplePathTemplate(this.uriTemplate), this.gateway.getGatewayVersion(), this.enabledVersion, loadBalancer, this.reverseHeaders);
        CuratorFramework curator = this.gateway.getCurator();
        this.mappingTree = new HttpMappingZooKeeperTreeCache(curator, (HttpMappingRule)this.httpMappingRuleBase, this.zooKeeperPath);
        this.mappingTree.init();
        this.gateway.addMappingRuleConfiguration((HttpMappingRule)this.httpMappingRuleBase);
    }

    @Deactivate
    void deactivate() {
        this.gateway.removeMappingRuleConfiguration((HttpMappingRule)this.httpMappingRuleBase);
        this.httpMappingRuleBase = null;
        this.deactivateInternal();
        this.deactivateComponent();
    }

    protected void deactivateInternal() {
        if (this.mappingTree != null) {
            this.mappingTree.destroy();
            this.mappingTree = null;
        }
    }

    public FabricHaproxyGateway getGateway() {
        return this.gateway;
    }

    public void setGateway(FabricHaproxyGateway gateway) {
        this.gateway = gateway;
    }

    public void unsetGateway(FabricHaproxyGateway gateway) {
        this.gateway = null;
    }

    public String getZooKeeperPath() {
        return this.zooKeeperPath;
    }

    public void setZooKeeperPath(String zooKeeperPath) {
        this.zooKeeperPath = zooKeeperPath;
    }

    public String getEnabledVersion() {
        return this.enabledVersion;
    }

    public void setEnabledVersion(String enabledVersion) {
        this.enabledVersion = enabledVersion;
    }

    public String getUriTemplate() {
        return this.uriTemplate;
    }

    public void setUriTemplate(String uriTemplate) {
        this.uriTemplate = uriTemplate;
    }

    public String getLoadBalancerType() {
        return this.loadBalancerType;
    }

    public void setLoadBalancerType(String loadBalancerType) {
        this.loadBalancerType = loadBalancerType;
    }

    protected void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    protected void unbindConfigurer(Configurer configurer) {
        if (this.configurer == configurer) {
            this.configurer = null;
        }
    }
}

