/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.loadbalancer;

import io.fabric8.gateway.SocketWrapper;
import io.fabric8.gateway.handlers.loadbalancer.ConnectionParameters;
import io.fabric8.gateway.loadbalancer.ClientRequestFacade;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class ClientRequestFacadeFactory {
    private final ArrayList<KeyExtractor> keyExtractors;

    public ClientRequestFacadeFactory(String extractors) {
        this(ClientRequestFacadeFactory.toExtractors(extractors));
    }

    private static ArrayList<KeyExtractor> toExtractors(String extractors) {
        String[] parts = extractors.split("[\\s,]+");
        ArrayList<KeyExtractor> rc = new ArrayList<KeyExtractor>(parts.length);
        for (String part : parts) {
            rc.add(KeyExtractors.valueOf(part.toUpperCase()));
        }
        return rc;
    }

    public ClientRequestFacadeFactory(KeyExtractor ... extractors) {
        this(Arrays.asList(extractors));
    }

    public ClientRequestFacadeFactory(Collection<KeyExtractor> extractors) {
        this.keyExtractors = new ArrayList<KeyExtractor>(extractors);
    }

    public ClientRequestFacade create(final SocketWrapper socket, final ConnectionParameters params) {
        return new ClientRequestFacade(){

            public String getClientRequestKey() {
                for (KeyExtractor extractor : ClientRequestFacadeFactory.this.keyExtractors) {
                    String value = extractor.extract(socket, params);
                    if (value == null) continue;
                    return value;
                }
                return null;
            }
        };
    }

    static enum KeyExtractors implements KeyExtractor
    {
        REMOTE_ADDRESS{

            @Override
            public String extract(SocketWrapper socket, ConnectionParameters connectionParameters) {
                InetSocketAddress address;
                if (socket != null && (address = socket.remoteAddress()) != null) {
                    return address.toString();
                }
                return null;
            }
        }
        ,
        LOCAL_ADDRESS{

            @Override
            public String extract(SocketWrapper socket, ConnectionParameters connectionParameters) {
                InetSocketAddress address;
                if (socket != null && (address = socket.localAddress()) != null) {
                    return address.toString();
                }
                return null;
            }
        }
        ,
        PROTOCOL_VIRTUAL_HOST{

            @Override
            public String extract(SocketWrapper socket, ConnectionParameters connectionParameters) {
                if (connectionParameters != null) {
                    return connectionParameters.protocolVirtualHost;
                }
                return null;
            }
        }
        ,
        PROTOCOL_USER{

            @Override
            public String extract(SocketWrapper socket, ConnectionParameters connectionParameters) {
                if (connectionParameters != null) {
                    return connectionParameters.protocolUser;
                }
                return null;
            }
        }
        ,
        PROTOCOL_CLIENT_ID{

            @Override
            public String extract(SocketWrapper socket, ConnectionParameters connectionParameters) {
                if (connectionParameters != null) {
                    return connectionParameters.protocolClientId;
                }
                return null;
            }
        }
        ,
        PROTOCOL_SESSION_ID{

            @Override
            public String extract(SocketWrapper socket, ConnectionParameters connectionParameters) {
                if (connectionParameters != null) {
                    return connectionParameters.protocolSessionId;
                }
                return null;
            }
        };

    }

    static interface KeyExtractor {
        public String extract(SocketWrapper var1, ConnectionParameters var2);
    }
}

