/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.detecting.protocol.stomp;

import io.fabric8.gateway.handlers.detecting.protocol.Ascii;
import io.fabric8.gateway.handlers.detecting.protocol.BufferSupport;
import io.fabric8.gateway.handlers.detecting.protocol.ProtocolDecoder;
import io.fabric8.gateway.handlers.detecting.protocol.stomp.Constants;
import io.fabric8.gateway.handlers.detecting.protocol.stomp.StompFrame;
import io.fabric8.gateway.handlers.detecting.protocol.stomp.StompProtocol;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.buffer.Buffer;

class StompProtocolDecoder
extends ProtocolDecoder<StompFrame> {
    private static final transient Logger LOG = LoggerFactory.getLogger(StompProtocolDecoder.class);
    private final StompProtocol protocol;
    public boolean trim = false;
    final ProtocolDecoder.Action<StompFrame> read_action = new ProtocolDecoder.Action<StompFrame>(){

        @Override
        public StompFrame apply() throws IOException {
            Buffer line = StompProtocolDecoder.this.readUntil((byte)10, 20, "The maximum command length was exceeded");
            if (line != null) {
                Buffer action = BufferSupport.chomp(line);
                if (StompProtocolDecoder.this.trim) {
                    action = BufferSupport.trim(action);
                }
                if (action.length() > 0) {
                    StompFrame frame = new StompFrame(Ascii.ascii(action));
                    StompProtocolDecoder.this.nextDecodeAction = StompProtocolDecoder.this.read_headers(frame);
                    return (StompFrame)StompProtocolDecoder.this.nextDecodeAction.apply();
                }
            }
            return null;
        }
    };

    public StompProtocolDecoder(StompProtocol protocol) {
        this.protocol = protocol;
    }

    @Override
    protected ProtocolDecoder.Action<StompFrame> initialDecodeAction() {
        return this.read_action;
    }

    private ProtocolDecoder.Action<StompFrame> read_headers(final StompFrame frame) {
        final Ascii[] contentLengthValue = new Ascii[1];
        final ArrayList headers = new ArrayList(10);
        return new ProtocolDecoder.Action<StompFrame>(){

            @Override
            public StompFrame apply() throws IOException {
                Buffer line = StompProtocolDecoder.this.readUntil((byte)10, ((StompProtocolDecoder)StompProtocolDecoder.this).protocol.maxHeaderLength, "The maximum header length was exceeded");
                while (line != null) {
                    if ((line = BufferSupport.chomp(line)).length() > 0) {
                        if (((StompProtocolDecoder)StompProtocolDecoder.this).protocol.maxHeaders != -1 && headers.size() > ((StompProtocolDecoder)StompProtocolDecoder.this).protocol.maxHeaders) {
                            throw new IOException("The maximum number of headers was exceeded");
                        }
                        try {
                            int seperatorIndex = BufferSupport.indexOf(line, (byte)58);
                            if (seperatorIndex < 0) {
                                throw new IOException("Header line missing separator [" + Ascii.ascii(line) + "]");
                            }
                            Buffer name = line.getBuffer(0, seperatorIndex);
                            if (StompProtocolDecoder.this.trim) {
                                name = BufferSupport.trim(name);
                            }
                            Buffer value = line.getBuffer(seperatorIndex + 1, line.length());
                            if (StompProtocolDecoder.this.trim) {
                                value = BufferSupport.trim(value);
                            }
                            StompFrame.HeaderEntry entry = new StompFrame.HeaderEntry(Ascii.ascii(name), Ascii.ascii(value));
                            if (entry.key.equals(Constants.CONTENT_LENGTH)) {
                                contentLengthValue[0] = entry.value;
                            }
                            headers.add(entry);
                        }
                        catch (Exception e) {
                            throw new IOException("Unable to parser header line [" + line + "]");
                        }
                    }
                    frame.setHeaders(headers);
                    Ascii contentLength = contentLengthValue[0];
                    if (contentLength != null) {
                        int length = 0;
                        try {
                            length = Integer.parseInt(contentLength.toString());
                        }
                        catch (NumberFormatException e) {
                            throw new IOException("Specified content-length is not a valid integer");
                        }
                        if (((StompProtocolDecoder)StompProtocolDecoder.this).protocol.maxDataLength != -1 && length > ((StompProtocolDecoder)StompProtocolDecoder.this).protocol.maxDataLength) {
                            throw new IOException("The maximum data length was exceeded");
                        }
                        StompProtocolDecoder.this.nextDecodeAction = StompProtocolDecoder.this.read_binary_body(frame, length);
                    } else {
                        StompProtocolDecoder.this.nextDecodeAction = StompProtocolDecoder.this.read_text_body(frame);
                    }
                    return (StompFrame)StompProtocolDecoder.this.nextDecodeAction.apply();
                    line = StompProtocolDecoder.this.readUntil((byte)10, ((StompProtocolDecoder)StompProtocolDecoder.this).protocol.maxHeaderLength, "The maximum header length was exceeded");
                }
                return null;
            }
        };
    }

    private ProtocolDecoder.Action<StompFrame> read_binary_body(final StompFrame frame, final int contentLength) {
        return new ProtocolDecoder.Action<StompFrame>(){

            @Override
            public StompFrame apply() throws IOException {
                Buffer content = StompProtocolDecoder.this.readBytes(contentLength + 1);
                if (content != null) {
                    if (content.getByte(contentLength) != 0) {
                        throw new IOException("Expected null terminator after " + contentLength + " content bytes");
                    }
                    frame.content(BufferSupport.chomp(content));
                    StompProtocolDecoder.this.nextDecodeAction = StompProtocolDecoder.this.read_action;
                    return frame;
                }
                return null;
            }
        };
    }

    private ProtocolDecoder.Action<StompFrame> read_text_body(final StompFrame frame) {
        return new ProtocolDecoder.Action<StompFrame>(){

            @Override
            public StompFrame apply() throws IOException {
                Buffer content = StompProtocolDecoder.this.readUntil((byte)0);
                if (content != null) {
                    StompProtocolDecoder.this.nextDecodeAction = StompProtocolDecoder.this.read_action;
                    frame.content(BufferSupport.chomp(content));
                    return frame;
                }
                return null;
            }
        };
    }
}

