/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.detecting.protocol.openwire.support;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;

public final class MarshallingSupport {
    public static final byte NULL = 0;
    public static final byte BOOLEAN_TYPE = 1;
    public static final byte BYTE_TYPE = 2;
    public static final byte CHAR_TYPE = 3;
    public static final byte SHORT_TYPE = 4;
    public static final byte INTEGER_TYPE = 5;
    public static final byte LONG_TYPE = 6;
    public static final byte DOUBLE_TYPE = 7;
    public static final byte FLOAT_TYPE = 8;
    public static final byte STRING_TYPE = 9;
    public static final byte BYTE_ARRAY_TYPE = 10;
    public static final byte MAP_TYPE = 11;
    public static final byte LIST_TYPE = 12;
    public static final byte BIG_STRING_TYPE = 13;

    private MarshallingSupport() {
    }

    public static void marshalPrimitiveMap(Map map, DataOutputStream out) throws IOException {
        if (map == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(map.size());
            for (String name : map.keySet()) {
                out.writeUTF(name);
                Object value = map.get(name);
                MarshallingSupport.marshalPrimitive(out, value);
            }
        }
    }

    public static Map<String, Object> unmarshalPrimitiveMap(DataInputStream in) throws IOException {
        return MarshallingSupport.unmarshalPrimitiveMap(in, Integer.MAX_VALUE);
    }

    public static Map<String, Object> unmarshalPrimitiveMap(DataInputStream in, int maxPropertySize) throws IOException {
        int size = in.readInt();
        if (size > maxPropertySize) {
            throw new IOException("Primitive map is larger than the allowed size: " + size);
        }
        if (size < 0) {
            return null;
        }
        HashMap<String, Object> rc = new HashMap<String, Object>(size);
        for (int i = 0; i < size; ++i) {
            String name = in.readUTF();
            rc.put(name, MarshallingSupport.unmarshalPrimitive(in));
        }
        return rc;
    }

    public static void marshalPrimitiveList(List list, DataOutputStream out) throws IOException {
        out.writeInt(list.size());
        for (Object element : list) {
            MarshallingSupport.marshalPrimitive(out, element);
        }
    }

    public static List<Object> unmarshalPrimitiveList(DataInputStream in) throws IOException {
        int size = in.readInt();
        ArrayList<Object> answer = new ArrayList<Object>(size);
        while (size-- > 0) {
            answer.add(MarshallingSupport.unmarshalPrimitive(in));
        }
        return answer;
    }

    public static void marshalPrimitive(DataOutputStream out, Object value) throws IOException {
        if (value == null) {
            MarshallingSupport.marshalNull(out);
        } else if (value.getClass() == Boolean.class) {
            MarshallingSupport.marshalBoolean(out, (Boolean)value);
        } else if (value.getClass() == Byte.class) {
            MarshallingSupport.marshalByte(out, (Byte)value);
        } else if (value.getClass() == Character.class) {
            MarshallingSupport.marshalChar(out, ((Character)value).charValue());
        } else if (value.getClass() == Short.class) {
            MarshallingSupport.marshalShort(out, (Short)value);
        } else if (value.getClass() == Integer.class) {
            MarshallingSupport.marshalInt(out, (Integer)value);
        } else if (value.getClass() == Long.class) {
            MarshallingSupport.marshalLong(out, (Long)value);
        } else if (value.getClass() == Float.class) {
            MarshallingSupport.marshalFloat(out, ((Float)value).floatValue());
        } else if (value.getClass() == Double.class) {
            MarshallingSupport.marshalDouble(out, (Double)value);
        } else if (value.getClass() == byte[].class) {
            MarshallingSupport.marshalByteArray(out, (byte[])value);
        } else if (value.getClass() == String.class) {
            MarshallingSupport.marshalString(out, (String)value);
        } else if (value instanceof Map) {
            out.writeByte(11);
            MarshallingSupport.marshalPrimitiveMap((Map)value, out);
        } else if (value instanceof List) {
            out.writeByte(12);
            MarshallingSupport.marshalPrimitiveList((List)value, out);
        } else {
            throw new IOException("Object is not a primitive: " + value);
        }
    }

    public static Object unmarshalPrimitive(DataInputStream in) throws IOException {
        Object value = null;
        byte type = in.readByte();
        switch (type) {
            case 2: {
                value = in.readByte();
                break;
            }
            case 1: {
                value = in.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 3: {
                value = Character.valueOf(in.readChar());
                break;
            }
            case 4: {
                value = in.readShort();
                break;
            }
            case 5: {
                value = in.readInt();
                break;
            }
            case 6: {
                value = in.readLong();
                break;
            }
            case 8: {
                value = new Float(in.readFloat());
                break;
            }
            case 7: {
                value = new Double(in.readDouble());
                break;
            }
            case 10: {
                value = new byte[in.readInt()];
                in.readFully((byte[])value);
                break;
            }
            case 9: {
                value = in.readUTF();
                break;
            }
            case 13: {
                value = MarshallingSupport.readUTF8(in);
                break;
            }
            case 11: {
                value = MarshallingSupport.unmarshalPrimitiveMap(in);
                break;
            }
            case 12: {
                value = MarshallingSupport.unmarshalPrimitiveList(in);
                break;
            }
            case 0: {
                value = null;
                break;
            }
            default: {
                throw new IOException("Unknown primitive type: " + type);
            }
        }
        return value;
    }

    public static void marshalNull(DataOutputStream out) throws IOException {
        out.writeByte(0);
    }

    public static void marshalBoolean(DataOutputStream out, boolean value) throws IOException {
        out.writeByte(1);
        out.writeBoolean(value);
    }

    public static void marshalByte(DataOutputStream out, byte value) throws IOException {
        out.writeByte(2);
        out.writeByte(value);
    }

    public static void marshalChar(DataOutputStream out, char value) throws IOException {
        out.writeByte(3);
        out.writeChar(value);
    }

    public static void marshalShort(DataOutputStream out, short value) throws IOException {
        out.writeByte(4);
        out.writeShort(value);
    }

    public static void marshalInt(DataOutputStream out, int value) throws IOException {
        out.writeByte(5);
        out.writeInt(value);
    }

    public static void marshalLong(DataOutputStream out, long value) throws IOException {
        out.writeByte(6);
        out.writeLong(value);
    }

    public static void marshalFloat(DataOutputStream out, float value) throws IOException {
        out.writeByte(8);
        out.writeFloat(value);
    }

    public static void marshalDouble(DataOutputStream out, double value) throws IOException {
        out.writeByte(7);
        out.writeDouble(value);
    }

    public static void marshalByteArray(DataOutputStream out, byte[] value) throws IOException {
        MarshallingSupport.marshalByteArray(out, value, 0, value.length);
    }

    public static void marshalByteArray(DataOutputStream out, byte[] value, int offset, int length) throws IOException {
        out.writeByte(10);
        out.writeInt(length);
        out.write(value, offset, length);
    }

    public static void marshalString(DataOutputStream out, String s) throws IOException {
        if (s.length() < 8191) {
            out.writeByte(9);
            out.writeUTF(s);
        } else {
            out.writeByte(13);
            MarshallingSupport.writeUTF8(out, s);
        }
    }

    public static void writeUTF8(DataOutput dataOut, String text) throws IOException {
        if (text != null) {
            int strlen = text.length();
            int utflen = 0;
            char[] charr = new char[strlen];
            char c = '\u0000';
            int count = 0;
            text.getChars(0, strlen, charr, 0);
            for (int i = 0; i < strlen; ++i) {
                c = charr[i];
                if (c >= '\u0001' && c <= '\u007f') {
                    ++utflen;
                    continue;
                }
                if (c > '\u07ff') {
                    utflen += 3;
                    continue;
                }
                utflen += 2;
            }
            byte[] bytearr = new byte[utflen + 4];
            bytearr[count++] = (byte)(utflen >>> 24 & 0xFF);
            bytearr[count++] = (byte)(utflen >>> 16 & 0xFF);
            bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
            bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
            for (int i = 0; i < strlen; ++i) {
                c = charr[i];
                if (c >= '\u0001' && c <= '\u007f') {
                    bytearr[count++] = (byte)c;
                    continue;
                }
                if (c > '\u07ff') {
                    bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                    bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                    bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                    continue;
                }
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            dataOut.write(bytearr);
        } else {
            dataOut.writeInt(-1);
        }
    }

    public static String readUTF8(DataInput dataIn) throws IOException {
        int utflen = dataIn.readInt();
        if (utflen > -1) {
            StringBuffer str = new StringBuffer(utflen);
            byte[] bytearr = new byte[utflen];
            int count = 0;
            dataIn.readFully(bytearr, 0, utflen);
            block5: while (count < utflen) {
                int c = bytearr[count] & 0xFF;
                switch (c >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        ++count;
                        str.append((char)c);
                        continue block5;
                    }
                    case 12: 
                    case 13: {
                        if ((count += 2) > utflen) {
                            throw new UTFDataFormatException();
                        }
                        byte char2 = bytearr[count - 1];
                        if ((char2 & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        str.append((char)((c & 0x1F) << 6 | char2 & 0x3F));
                        continue block5;
                    }
                    case 14: {
                        if ((count += 3) > utflen) {
                            throw new UTFDataFormatException();
                        }
                        byte char2 = bytearr[count - 2];
                        byte char3 = bytearr[count - 1];
                        if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        str.append((char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0));
                        continue block5;
                    }
                }
                throw new UTFDataFormatException();
            }
            return new String(str);
        }
        return null;
    }

    public static String propertiesToString(Properties props) throws IOException {
        String result = "";
        if (props != null) {
            DataByteArrayOutputStream dataOut = new DataByteArrayOutputStream();
            props.store((OutputStream)dataOut, "");
            result = new String(dataOut.getData(), 0, dataOut.size());
            dataOut.close();
        }
        return result;
    }

    public static Properties stringToProperties(String str) throws IOException {
        Properties result = new Properties();
        if (str != null && str.length() > 0) {
            DataByteArrayInputStream dataIn = new DataByteArrayInputStream(str.getBytes());
            result.load((InputStream)dataIn);
            dataIn.close();
        }
        return result;
    }

    public static String truncate64(String text) {
        if (text.length() > 63) {
            text = text.substring(0, 45) + "..." + text.substring(text.length() - 12);
        }
        return text;
    }
}

