/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway;

import java.net.InetSocketAddress;
import org.vertx.java.core.http.WebSocketBase;
import org.vertx.java.core.net.NetSocket;
import org.vertx.java.core.streams.ReadStream;
import org.vertx.java.core.streams.WriteStream;

public abstract class SocketWrapper {
    public abstract ReadStream<ReadStream> readStream();

    public abstract WriteStream<WriteStream> writeStream();

    public abstract void close();

    public abstract Object stream();

    public abstract InetSocketAddress localAddress();

    public abstract InetSocketAddress remoteAddress();

    public static SocketWrapper wrap(NetSocket socket) {
        return new NetSocketWrapper(socket);
    }

    public static SocketWrapper wrap(WebSocketBase socket) {
        return new WebSocketWrapper(socket);
    }

    static class WebSocketWrapper
    extends SocketWrapper {
        private final WebSocketBase socket;

        public WebSocketWrapper(WebSocketBase socket) {
            this.socket = socket;
        }

        @Override
        public void close() {
            this.socket.close();
        }

        public ReadStream readStream() {
            return this.socket;
        }

        public WriteStream writeStream() {
            return this.socket;
        }

        @Override
        public Object stream() {
            return this.socket;
        }

        @Override
        public InetSocketAddress localAddress() {
            return this.socket.localAddress();
        }

        @Override
        public InetSocketAddress remoteAddress() {
            return this.socket.remoteAddress();
        }
    }

    static class NetSocketWrapper
    extends SocketWrapper {
        private final NetSocket socket;

        public NetSocketWrapper(NetSocket socket) {
            this.socket = socket;
        }

        @Override
        public void close() {
            this.socket.close();
        }

        public ReadStream readStream() {
            return this.socket;
        }

        public WriteStream writeStream() {
            return this.socket;
        }

        @Override
        public Object stream() {
            return this.socket;
        }

        @Override
        public InetSocketAddress localAddress() {
            return this.socket.localAddress();
        }

        @Override
        public InetSocketAddress remoteAddress() {
            return this.socket.remoteAddress();
        }
    }
}

