/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.detecting.protocol.openwire;

import io.fabric8.gateway.handlers.detecting.protocol.ProtocolDecoder;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.OpenwireProtocol;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.codec.OpenWireFormat;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.command.Command;
import java.io.IOException;
import java.net.ProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.buffer.Buffer;

class OpenwireProtocolDecoder
extends ProtocolDecoder<Command> {
    private static final transient Logger LOG = LoggerFactory.getLogger(OpenwireProtocolDecoder.class);
    OpenWireFormat format = new OpenWireFormat(1);
    private final OpenwireProtocol protocol;
    public boolean trim = false;
    final ProtocolDecoder.Action<Command> read_action = new ProtocolDecoder.Action<Command>(){

        @Override
        public Command apply() throws IOException {
            Buffer header = OpenwireProtocolDecoder.this.peekBytes(4);
            if (header == null) {
                return null;
            }
            final int length = header.getInt(0);
            if (length > ((OpenwireProtocolDecoder)OpenwireProtocolDecoder.this).protocol.maxFrameSize) {
                throw new ProtocolException("Max frame size exceeded.");
            }
            OpenwireProtocolDecoder.this.nextDecodeAction = new ProtocolDecoder.Action<Command>(){

                @Override
                public Command apply() throws IOException {
                    Buffer frame = OpenwireProtocolDecoder.this.readBytes(4 + length);
                    if (frame == null) {
                        return null;
                    }
                    org.fusesource.hawtbuf.Buffer buffer = new org.fusesource.hawtbuf.Buffer(frame.getBytes());
                    Command command = (Command)OpenwireProtocolDecoder.this.format.unmarshal(buffer);
                    OpenwireProtocolDecoder.this.nextDecodeAction = OpenwireProtocolDecoder.this.read_action;
                    return command;
                }
            };
            return (Command)OpenwireProtocolDecoder.this.nextDecodeAction.apply();
        }
    };

    public OpenwireProtocolDecoder(OpenwireProtocol protocol) {
        this.protocol = protocol;
    }

    @Override
    protected ProtocolDecoder.Action<Command> initialDecodeAction() {
        return this.read_action;
    }
}

