/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.detecting.protocol.ssl;

import io.fabric8.gateway.SocketWrapper;
import io.fabric8.gateway.handlers.detecting.Protocol;
import io.fabric8.gateway.handlers.loadbalancer.ConnectionParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;

public class SslProtocol
implements Protocol {
    private static final transient Logger LOG = LoggerFactory.getLogger(SslProtocol.class);
    private static final String[] SCHEMES = new String[]{"ssl"};

    @Override
    public String getProtocolName() {
        return "ssl";
    }

    @Override
    public String[] getProtocolSchemes() {
        return SCHEMES;
    }

    @Override
    public int getMaxIdentificationLength() {
        return 6;
    }

    @Override
    public boolean matches(Buffer buffer) {
        if (buffer.length() >= 6) {
            if (buffer.getByte(0) == 22) {
                return buffer.getByte(5) == 1 && (buffer.getByte(1) == 2 || buffer.getByte(1) == 3 && this.isSSLVerions(buffer.getByte(2)));
            }
            return (buffer.getByte(0) & 0xC0) == 128 && buffer.getByte(2) == 1 && (buffer.getByte(3) == 2 || buffer.getByte(3) == 3 && this.isSSLVerions(buffer.getByte(4)));
        }
        return false;
    }

    private boolean isSSLVerions(byte ver) {
        switch (ver) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void snoopConnectionParameters(SocketWrapper socket, Buffer received, Handler<ConnectionParameters> handler) {
        handler.handle((Object)new ConnectionParameters());
    }
}

