/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.loadbalancer;

import io.fabric8.common.util.Strings;
import io.fabric8.gateway.loadbalancer.LoadBalancer;
import io.fabric8.gateway.loadbalancer.RandomLoadBalancer;
import io.fabric8.gateway.loadbalancer.RoundRobinLoadBalancer;
import io.fabric8.gateway.loadbalancer.StickyLoadBalancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancers {
    private static final transient Logger LOG = LoggerFactory.getLogger(LoadBalancers.class);
    public static final String RANDOM_LOAD_BALANCER = "random";
    public static final String ROUND_ROBIN_LOAD_BALANCER = "roundrobin";
    public static final String STICKY_LOAD_BALANCER = "sticky";
    public static final int STICKY_LOAD_BALANCER_DEFAULT_CACHE_SIZE = 10000;

    public static <T> LoadBalancer<T> createLoadBalancer(String loadBalancerType, int stickyLoadBalancerCacheSize) {
        if (RANDOM_LOAD_BALANCER.equals(loadBalancerType)) {
            return new RandomLoadBalancer();
        }
        if (ROUND_ROBIN_LOAD_BALANCER.equals(loadBalancerType)) {
            return new RoundRobinLoadBalancer();
        }
        if (STICKY_LOAD_BALANCER.equals(loadBalancerType)) {
            return new StickyLoadBalancer(stickyLoadBalancerCacheSize);
        }
        if (Strings.isNotBlank((String)loadBalancerType)) {
            LOG.warn("Ignored invalid load balancer type: " + loadBalancerType);
        }
        return new RoundRobinLoadBalancer();
    }
}

