/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.detecting.protocol.openwire.command;

import io.fabric8.gateway.handlers.detecting.protocol.openwire.codec.OpenWireFormat;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.command.ActiveMQMessage;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.command.Message;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.support.MarshallingSupport;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.support.OpenwireException;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.support.Settings;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.ByteArrayInputStream;
import org.fusesource.hawtbuf.ByteArrayOutputStream;

public class ActiveMQMapMessage
extends ActiveMQMessage {
    public static final byte DATA_STRUCTURE_TYPE = 25;
    protected transient Map<String, Object> map = new HashMap<String, Object>();

    private Object readResolve() throws ObjectStreamException {
        if (this.map == null) {
            this.map = new HashMap<String, Object>();
        }
        return this;
    }

    @Override
    public Message copy() {
        ActiveMQMapMessage copy = new ActiveMQMapMessage();
        this.copy(copy);
        return copy;
    }

    private void copy(ActiveMQMapMessage copy) {
        this.storeContent();
        super.copy(copy);
    }

    @Override
    public void beforeMarshall(OpenWireFormat wireFormat) throws IOException {
        super.beforeMarshall(wireFormat);
        this.storeContent();
    }

    @Override
    public void clearMarshalledState() {
        super.clearMarshalledState();
        this.map.clear();
    }

    private void storeContent() {
        try {
            if (this.getContent() == null && !this.map.isEmpty()) {
                ByteArrayOutputStream bytesOut;
                OutputStream os = bytesOut = new ByteArrayOutputStream();
                if (Settings.enable_compression()) {
                    this.compressed = true;
                    os = new DeflaterOutputStream(os);
                }
                DataOutputStream dataOut = new DataOutputStream(os);
                MarshallingSupport.marshalPrimitiveMap(this.map, dataOut);
                dataOut.close();
                this.setContent(bytesOut.toBuffer());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadContent() throws OpenwireException {
        try {
            if (this.getContent() != null && this.map.isEmpty()) {
                Buffer content = this.getContent();
                InputStream is = new ByteArrayInputStream(content);
                if (this.isCompressed()) {
                    is = new InflaterInputStream(is);
                }
                DataInputStream dataIn = new DataInputStream(is);
                this.map = MarshallingSupport.unmarshalPrimitiveMap(dataIn);
                dataIn.close();
            }
        }
        catch (IOException e) {
            throw new OpenwireException(e);
        }
    }

    @Override
    public byte getDataStructureType() {
        return 25;
    }

    public String getJMSXMimeType() {
        return "jms/map-message";
    }

    @Override
    public void clearBody() throws OpenwireException {
        super.clearBody();
        this.map.clear();
    }

    public boolean getBoolean(String name) throws OpenwireException {
        this.initializeReading();
        Object value = this.map.get(name);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf(value.toString());
        }
        throw new OpenwireException(" cannot read a boolean from " + value.getClass().getName());
    }

    public byte getByte(String name) throws OpenwireException {
        this.initializeReading();
        Object value = this.map.get(name);
        if (value == null) {
            return 0;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            return Byte.valueOf(value.toString());
        }
        throw new OpenwireException(" cannot read a byte from " + value.getClass().getName());
    }

    public short getShort(String name) throws OpenwireException {
        this.initializeReading();
        Object value = this.map.get(name);
        if (value == null) {
            return 0;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Byte) {
            return ((Byte)value).shortValue();
        }
        if (value instanceof String) {
            return Short.valueOf(value.toString());
        }
        throw new OpenwireException(" cannot read a short from " + value.getClass().getName());
    }

    public char getChar(String name) throws OpenwireException {
        this.initializeReading();
        Object value = this.map.get(name);
        if (value == null) {
            throw new NullPointerException();
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        throw new OpenwireException(" cannot read a short from " + value.getClass().getName());
    }

    public int getInt(String name) throws OpenwireException {
        this.initializeReading();
        Object value = this.map.get(name);
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Short) {
            return ((Short)value).intValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).intValue();
        }
        if (value instanceof String) {
            return Integer.valueOf(value.toString());
        }
        throw new OpenwireException(" cannot read an int from " + value.getClass().getName());
    }

    public long getLong(String name) throws OpenwireException {
        this.initializeReading();
        Object value = this.map.get(name);
        if (value == null) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Short) {
            return ((Short)value).longValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).longValue();
        }
        if (value instanceof String) {
            return Long.valueOf(value.toString());
        }
        throw new OpenwireException(" cannot read a long from " + value.getClass().getName());
    }

    public float getFloat(String name) throws OpenwireException {
        this.initializeReading();
        Object value = this.map.get(name);
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof String) {
            return Float.valueOf(value.toString()).floatValue();
        }
        throw new OpenwireException(" cannot read a float from " + value.getClass().getName());
    }

    public double getDouble(String name) throws OpenwireException {
        this.initializeReading();
        Object value = this.map.get(name);
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof String) {
            return Float.valueOf(value.toString()).floatValue();
        }
        throw new OpenwireException(" cannot read a double from " + value.getClass().getName());
    }

    public String getString(String name) throws OpenwireException {
        this.initializeReading();
        Object value = this.map.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            throw new OpenwireException("Use getBytes to read a byte array");
        }
        return value.toString();
    }

    public byte[] getBytes(String name) throws OpenwireException {
        this.initializeReading();
        Object value = this.map.get(name);
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        throw new OpenwireException(" cannot read a byte[] from " + value.getClass().getName());
    }

    public Object getObject(String name) throws OpenwireException {
        this.initializeReading();
        return this.map.get(name);
    }

    public Enumeration<String> getMapNames() throws OpenwireException {
        this.initializeReading();
        return Collections.enumeration(this.map.keySet());
    }

    protected void put(String name, Object value) throws OpenwireException {
        if (name == null) {
            throw new IllegalArgumentException("The name of the property cannot be null.");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("The name of the property cannot be an emprty string.");
        }
        this.map.put(name, value);
    }

    public void setBoolean(String name, boolean value) throws OpenwireException {
        this.initializeWriting();
        this.put(name, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setByte(String name, byte value) throws OpenwireException {
        this.initializeWriting();
        this.put(name, value);
    }

    public void setShort(String name, short value) throws OpenwireException {
        this.initializeWriting();
        this.put(name, value);
    }

    public void setChar(String name, char value) throws OpenwireException {
        this.initializeWriting();
        this.put(name, Character.valueOf(value));
    }

    public void setInt(String name, int value) throws OpenwireException {
        this.initializeWriting();
        this.put(name, value);
    }

    public void setLong(String name, long value) throws OpenwireException {
        this.initializeWriting();
        this.put(name, value);
    }

    public void setFloat(String name, float value) throws OpenwireException {
        this.initializeWriting();
        this.put(name, new Float(value));
    }

    public void setDouble(String name, double value) throws OpenwireException {
        this.initializeWriting();
        this.put(name, new Double(value));
    }

    public void setString(String name, String value) throws OpenwireException {
        this.initializeWriting();
        this.put(name, value);
    }

    public void setBytes(String name, byte[] value) throws OpenwireException {
        this.initializeWriting();
        if (value != null) {
            this.put(name, value);
        } else {
            this.map.remove(name);
        }
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws OpenwireException {
        this.initializeWriting();
        byte[] data = new byte[length];
        System.arraycopy(value, offset, data, 0, length);
        this.put(name, data);
    }

    public void setObject(String name, Object value) throws OpenwireException {
        this.initializeWriting();
        if (value != null) {
            if (!(value instanceof byte[])) {
                this.checkValidObject(value);
            }
            this.put(name, value);
        } else {
            this.put(name, null);
        }
    }

    public boolean itemExists(String name) throws OpenwireException {
        this.initializeReading();
        return this.map.containsKey(name);
    }

    private void initializeReading() throws OpenwireException {
        this.loadContent();
    }

    private void initializeWriting() throws OpenwireException {
        this.checkReadOnlyBody();
        this.setContent(null);
    }

    @Override
    public String toString() {
        return super.toString() + " ActiveMQMapMessage{ " + "theTable = " + this.map + " }";
    }

    public Map<String, Object> getContentMap() throws OpenwireException {
        this.initializeReading();
        return this.map;
    }
}

