/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.detecting.protocol.http;

import io.fabric8.gateway.SocketWrapper;
import io.fabric8.gateway.handlers.detecting.Protocol;
import io.fabric8.gateway.handlers.detecting.protocol.Ascii;
import io.fabric8.gateway.handlers.detecting.protocol.BufferSupport;
import io.fabric8.gateway.loadbalancer.ConnectionParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;

public class HttpProtocol
implements Protocol {
    private static final transient Logger LOG = LoggerFactory.getLogger(HttpProtocol.class);
    final Ascii CONNECT = Ascii.ascii("CONNECT ");
    final Ascii GET = Ascii.ascii("GET ");
    final Ascii PUT = Ascii.ascii("PUT ");
    final Ascii POST = Ascii.ascii("POST ");
    final Ascii DELETE = Ascii.ascii("DELETE ");
    final Ascii OPTIONS = Ascii.ascii("OPTIONS ");
    final Ascii HEAD = Ascii.ascii("HEAD ");
    final Ascii TRACE = Ascii.ascii("TRACE ");
    private static final String[] SCHEMES = new String[]{"http"};

    @Override
    public String getProtocolName() {
        return "http";
    }

    @Override
    public String[] getProtocolSchemes() {
        return SCHEMES;
    }

    @Override
    public int getMaxIdentificationLength() {
        return this.CONNECT.toBuffer().length();
    }

    @Override
    public boolean matches(Buffer header) {
        return BufferSupport.startsWith(header, 0, this.GET.toBuffer()) || BufferSupport.startsWith(header, 0, this.HEAD.toBuffer()) || BufferSupport.startsWith(header, 0, this.POST.toBuffer()) || BufferSupport.startsWith(header, 0, this.PUT.toBuffer()) || BufferSupport.startsWith(header, 0, this.DELETE.toBuffer()) || BufferSupport.startsWith(header, 0, this.OPTIONS.toBuffer()) || BufferSupport.startsWith(header, 0, this.TRACE.toBuffer()) || BufferSupport.startsWith(header, 0, this.CONNECT.toBuffer());
    }

    @Override
    public void snoopConnectionParameters(SocketWrapper socket, Buffer received, Handler<ConnectionParameters> handler) {
        handler.handle(new ConnectionParameters());
    }
}

