/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.kubernetes;

import io.fabric8.forge.kubernetes.AbstractKubernetesCommand;
import io.fabric8.kubernetes.api.Controller;
import io.fabric8.utils.Files;
import java.io.File;
import javax.inject.Inject;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.validate.UIValidator;

public class Apply
extends AbstractKubernetesCommand {
    @Inject
    @WithAttributes(name="file", label="JSON file", description="The JSON file of configuration to apply to Kubernetes.", required=true)
    UIInput<File> file;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).category(Categories.create((String[])new String[]{CATEGORY})).name(CATEGORY + ": Apply").description("Applies the given JSON configuration to kubernetes to create pods, replication controllers or services");
    }

    @Override
    public void initializeUI(UIBuilder builder) throws Exception {
        super.initializeUI(builder);
        this.file.addValidator(new UIValidator(){

            public void validate(UIValidationContext validationContext) {
                InputComponent inputComponent = validationContext.getCurrentInputComponent();
                Object value = inputComponent.getValue();
                if (value instanceof File) {
                    File aFile = (File)value;
                    if (!aFile.exists()) {
                        validationContext.addValidationError(inputComponent, "File does not exist!");
                    } else if (!aFile.isFile()) {
                        validationContext.addValidationError(inputComponent, "File is a directory!");
                    } else {
                        String extension = Files.getFileExtension((File)aFile);
                        if (extension == null || !extension.toLowerCase().equals("json")) {
                            validationContext.addValidationWarning(inputComponent, "File does not use the .json extension");
                        }
                    }
                }
            }
        });
        builder.add(this.file);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        File applyFile = (File)this.file.getValue();
        Controller controller = new Controller(this.getKubernetes());
        controller.applyJson(applyFile);
        return null;
    }
}

