/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.kubernetes;

import io.fabric8.forge.kubernetes.AbstractKubernetesCommand;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.ServiceListSchema;
import io.fabric8.kubernetes.api.model.ServiceSchema;
import io.fabric8.utils.Filter;
import io.fabric8.utils.TablePrinter;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class ServiceList
extends AbstractKubernetesCommand {
    @Inject
    @WithAttributes(name="filter", label="The text filter used to filter pods using label selectors")
    UIInput<String> filterText;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).category(Categories.create((String[])new String[]{CATEGORY})).name(CATEGORY + ": Service List").description("Lists the services in a kubernetes cloud");
    }

    @Override
    public void initializeUI(UIBuilder builder) throws Exception {
        super.initializeUI(builder);
        builder.add(this.filterText);
    }

    public Result execute(UIExecutionContext uiExecutionContext) throws Exception {
        KubernetesClient kubernetes = this.getKubernetes();
        ServiceListSchema services = kubernetes.getServices();
        this.printServices(services, System.out);
        return null;
    }

    private void printServices(ServiceListSchema services, PrintStream out) {
        TablePrinter table = new TablePrinter();
        table.columns(new String[]{"id", "labels", "selector", "port"});
        List items = services.getItems();
        if (items == null) {
            items = Collections.EMPTY_LIST;
        }
        Filter filter = KubernetesHelper.createServiceFilter((String)((String)this.filterText.getValue()));
        for (ServiceSchema item : items) {
            if (!filter.matches((Object)item)) continue;
            String labels = KubernetesHelper.toLabelsString((Map)item.getLabels());
            String selector = KubernetesHelper.toLabelsString((Map)item.getSelector());
            table.row(new String[]{item.getId(), labels, selector, KubernetesHelper.toPositiveNonZeroText((Integer)item.getPort())});
        }
        table.print();
    }
}

