/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.kubernetes;

import io.fabric8.forge.kubernetes.AbstractKubernetesCommand;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.utils.Filter;
import io.fabric8.utils.TablePrinter;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class ServicesList
extends AbstractKubernetesCommand {
    @Inject
    @WithAttributes(name="filter", label="The text filter used to filter pods using label selectors")
    UIInput<String> filterText;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).category(Categories.create((String[])new String[]{CATEGORY})).name(CATEGORY + ": Service List").description("Lists the services in a kubernetes cloud");
    }

    @Override
    public void initializeUI(UIBuilder builder) throws Exception {
        super.initializeUI(builder);
        builder.add(this.filterText);
    }

    public Result execute(UIExecutionContext uiExecutionContext) throws Exception {
        ServiceList services = this.getKubernetes().getServices();
        this.printServices(services, System.out);
        return null;
    }

    private void printServices(ServiceList services, PrintStream out) {
        TablePrinter table = new TablePrinter();
        table.columns(new String[]{"id", "labels", "selector", "port"});
        List items = services.getItems();
        if (items == null) {
            items = Collections.EMPTY_LIST;
        }
        Filter filter = KubernetesHelper.createServiceFilter((String)((String)this.filterText.getValue()));
        for (Service service : items) {
            if (!filter.matches((Object)service)) continue;
            String labels = KubernetesHelper.toLabelsString((Map)service.getLabels());
            String selector = KubernetesHelper.toLabelsString((Map)KubernetesHelper.getSelector((Service)service));
            table.row(new String[]{KubernetesHelper.getId((Service)service), labels, selector, KubernetesHelper.toPositiveNonZeroText((Integer)KubernetesHelper.getPort((Service)service))});
        }
        table.print();
    }
}

