/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.kubernetes;

import io.fabric8.forge.kubernetes.AbstractKubernetesCommand;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class ReplicationControllerDelete
extends AbstractKubernetesCommand {
    @Inject
    @WithAttributes(label="Replication Controller ID", description="The ID of the replication controller to delete.", required=true)
    UIInput<String> replicationControllerId;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).category(Categories.create((String[])new String[]{CATEGORY})).name(CATEGORY + ": Replication Controller Delete").description("Deletes the given replication controller from the kubernetes cloud");
    }

    @Override
    public void initializeUI(UIBuilder builder) throws Exception {
        super.initializeUI(builder);
        this.replicationControllerId.setCompleter((UICompleter)new UICompleter<String>(){

            public Iterable<String> getCompletionProposals(UIContext context, InputComponent<?, String> input, String value) {
                List items;
                ArrayList<String> list = new ArrayList<String>();
                ReplicationControllerList replicationControllers = ReplicationControllerDelete.this.getKubernetes().getReplicationControllers();
                if (replicationControllers != null && (items = replicationControllers.getItems()) != null) {
                    for (ReplicationController item : items) {
                        String id = KubernetesHelper.getId((ReplicationController)item);
                        list.add(id);
                    }
                }
                Collections.sort(list);
                return list;
            }
        });
        builder.add(this.replicationControllerId);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        String idText;
        KubernetesClient kubernetes = this.getKubernetes();
        ReplicationController replicationController = kubernetes.getReplicationController(idText = (String)this.replicationControllerId.getValue());
        if (replicationController == null) {
            System.out.println("No replicationController for id: " + idText);
        } else {
            this.executeReplicationController(replicationController);
        }
        return null;
    }

    protected void executeReplicationController(ReplicationController replicationController) throws Exception {
        this.getKubernetes().deleteReplicationController(KubernetesHelper.getId((ReplicationController)replicationController));
    }
}

