/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.kubernetes;

import io.fabric8.forge.kubernetes.AbstractKubernetesCommand;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.model.PodListSchema;
import io.fabric8.kubernetes.api.model.PodSchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;

public abstract class AbstractPodCommand
extends AbstractKubernetesCommand {
    @Inject
    @WithAttributes(label="Pod ID", description="The ID of the pod.", required=true)
    UIInput<String> podId;

    @Override
    public void initializeUI(UIBuilder builder) throws Exception {
        super.initializeUI(builder);
        this.podId.setCompleter((UICompleter)new UICompleter<String>(){

            public Iterable<String> getCompletionProposals(UIContext context, InputComponent<?, String> input, String value) {
                List items;
                ArrayList<String> list = new ArrayList<String>();
                PodListSchema pods = AbstractPodCommand.this.getKubernetes().getPods();
                if (pods != null && (items = pods.getItems()) != null) {
                    for (PodSchema item : items) {
                        String id = item.getId();
                        list.add(id);
                    }
                }
                Collections.sort(list);
                System.out.println("Completion list is " + list);
                return list;
            }
        });
        builder.add(this.podId);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        String podIdText;
        KubernetesClient kubernetes = this.getKubernetes();
        PodSchema podInfo = kubernetes.getPod(podIdText = (String)this.podId.getValue());
        if (podInfo == null) {
            System.out.println("No pod for id: " + podIdText);
        } else {
            this.executePod(podInfo, podIdText);
        }
        return null;
    }

    protected abstract void executePod(PodSchema var1, String var2) throws Exception;
}

