/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.ConfigureComponentPropertiesStep;
import io.fabric8.forge.camel.commands.project.completer.SpringBootConfigurationFileCompleter;
import io.fabric8.forge.camel.commands.project.dto.ComponentDto;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import io.fabric8.forge.camel.commands.project.helper.CollectionHelper;
import io.fabric8.forge.camel.commands.project.helper.PoorMansLogger;
import io.fabric8.forge.camel.commands.project.helper.StringHelper;
import io.fabric8.forge.camel.commands.project.model.InputOptionByGroup;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultBuilder;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;

public class CamelEditComponentCommand
extends AbstractCamelProjectCommand
implements UIWizard {
    private static final PoorMansLogger LOG = new PoorMansLogger(false);
    private static final int MAX_OPTIONS = 20;
    @Inject
    @WithAttributes(label="Components", required=true, description="The components from the project")
    private UISelectOne<ComponentDto> componentName;
    @Inject
    private InputComponentFactory componentFactory;
    @Inject
    private DependencyInstaller dependencyInstaller;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelEditComponentCommand.class).name("Camel: Edit Component").category(Categories.create((String[])new String[]{CATEGORY})).description("Edit Camel component");
    }

    @Override
    public boolean isEnabled(UIContext context) {
        boolean answer = super.isEnabled(context);
        if (answer) {
            Project project = this.getSelectedProject(context);
            answer = CamelCommandsHelper.isSpringBootProject(project);
        }
        return answer;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)builder);
        Map attributeMap = builder.getUIContext().getAttributeMap();
        attributeMap.remove("navigationResult");
        Iterable<ComponentDto> it = CamelCommandsHelper.createComponentDtoValues(project, this.getCamelCatalog(), null, false, false, false, true).call();
        this.componentName.setValueChoices(it);
        builder.add(this.componentName);
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        NavigationResult navigationResult;
        Map attributeMap = context.getUIContext().getAttributeMap();
        ComponentDto selectedComponent = (ComponentDto)this.componentName.getValue();
        if ("<select>".equals(selectedComponent)) {
            attributeMap.remove("navigationResult");
            return null;
        }
        String previous = (String)attributeMap.get("componentName");
        if (previous != null && previous.equals(selectedComponent.getScheme()) && (navigationResult = (NavigationResult)attributeMap.get("navigationResult")) != null) {
            return navigationResult;
        }
        LOG.info("Component: " + selectedComponent.getScheme());
        String json = this.getCamelCatalog().componentJSonSchema(selectedComponent.getScheme());
        if (json == null) {
            throw new IllegalArgumentException("Could not find catalog entry for component name: " + selectedComponent.getScheme());
        }
        LOG.info("Component json: " + json);
        attributeMap.put("componentName", selectedComponent.getScheme());
        attributeMap.put("mode", "edit");
        attributeMap.put("kind", "springboot");
        LinkedHashMap<String, String> currentValues = Collections.EMPTY_MAP;
        SpringBootConfigurationFileCompleter xmlFileCompleter = this.createSpringBootConfigurationFileCompleter(context.getUIContext(), null);
        Set<String> files = xmlFileCompleter.getFiles();
        if (files.size() >= 1) {
            String file = CollectionHelper.first(files);
            attributeMap.put("applicationFile", file);
            LOG.info("Application configuration file: " + file);
            ResourcesFacet facet = (ResourcesFacet)this.getSelectedProject((UIContextProvider)context).getFacet(ResourcesFacet.class);
            FileResource fr = facet.getResource(file);
            String data = fr.getContents();
            boolean yaml = file.endsWith(".yaml") || file.endsWith(".yml");
            boolean properties = file.endsWith(".properties");
            String prefix = "camel.component." + selectedComponent.getScheme() + ".";
            if (!yaml && properties) {
                Properties prop = new Properties();
                prop.load(new StringReader(data));
                currentValues = new LinkedHashMap<String, String>();
                for (String key : prop.stringPropertyNames()) {
                    String value = prop.getProperty(key);
                    if (!(key = StringHelper.dashToCamelCase(key)).startsWith(prefix)) continue;
                    key = key.substring(prefix.length());
                    currentValues.put(key, value);
                    LOG.info("Current value " + key + "=" + value);
                }
            }
        } else {
            attributeMap.put("applicationFile", "application.properties");
        }
        UIContext ui = context.getUIContext();
        List<InputOptionByGroup> groups = CamelCommandsHelper.createUIInputsForCamelComponent(selectedComponent.getScheme(), (Map<String, String>)currentValues, 20, this.getCamelCatalog(), this.componentFactory, this.converterFactory, ui);
        ArrayList<InputComponent> allInputs = new ArrayList<InputComponent>();
        for (InputOptionByGroup group : groups) {
            allInputs.addAll(group.getInputs());
        }
        LOG.info(allInputs.size() + " input fields in the UI wizard");
        NavigationResultBuilder builder = Results.navigationBuilder();
        int pages = groups.size();
        for (int i = 0; i < pages; ++i) {
            boolean last = i == pages - 1;
            InputOptionByGroup current = groups.get(i);
            ConfigureComponentPropertiesStep step = new ConfigureComponentPropertiesStep(this.projectFactory, this.dependencyInstaller, this.getCamelCatalog(), selectedComponent.getScheme(), current.getGroup(), allInputs, current.getInputs(), last, i, pages);
            builder.add((UICommand)step);
        }
        NavigationResult navigationResult2 = builder.build();
        attributeMap.put("navigationResult", navigationResult2);
        return navigationResult2;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        return null;
    }
}

