/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.ConfigureEndpointPropertiesStep;
import io.fabric8.forge.camel.commands.project.completer.CurrentLineCompleter;
import io.fabric8.forge.camel.commands.project.completer.RouteBuilderEndpointsCompleter;
import io.fabric8.forge.camel.commands.project.completer.XmlEndpointsCompleter;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import io.fabric8.forge.camel.commands.project.helper.PoorMansLogger;
import io.fabric8.forge.camel.commands.project.model.CamelEndpointDetails;
import io.fabric8.forge.camel.commands.project.model.InputOptionByGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultBuilder;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;

public class CamelEditEndpointCommand
extends AbstractCamelProjectCommand
implements UIWizard {
    private static final PoorMansLogger LOG = new PoorMansLogger(false);
    private static final int MAX_OPTIONS = 20;
    @Inject
    @WithAttributes(label="Endpoints", required=true, description="The endpoints from the project")
    private UISelectOne<String> endpoints;
    @Inject
    private InputComponentFactory componentFactory;
    @Inject
    private DependencyInstaller dependencyInstaller;
    private RouteBuilderEndpointsCompleter javaCompleter;
    private XmlEndpointsCompleter xmlCompleter;
    private CurrentLineCompleter currentLineCompleter;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelEditEndpointCommand.class).name("Camel: Edit Endpoint").category(Categories.create((String[])new String[]{CATEGORY})).description("Edit Camel endpoint in the current file");
    }

    @Override
    public boolean isEnabled(UIContext context) {
        boolean answer = super.isEnabled(context);
        if (answer && this.isRunningInGui(context)) {
            LOG.info("Running in gui");
            String currentFile = this.getSelectedFile(context);
            answer = currentFile != null;
        }
        return answer;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Map attributeMap = builder.getUIContext().getAttributeMap();
        attributeMap.remove("navigationResult");
        String selectedFile = this.getSelectedFile(builder.getUIContext());
        String currentFile = this.asRelativeFile(builder.getUIContext(), selectedFile);
        int cursorLineNumber = this.getCurrentCursorLine(builder.getUIContext());
        LOG.info("Current file " + currentFile + " line number: " + cursorLineNumber);
        boolean javaFile = this.isSelectedFileJava(builder.getUIContext());
        boolean xmlFile = this.isSelectedFileXml(builder.getUIContext());
        if (javaFile) {
            LOG.info("Java file");
            this.javaCompleter = this.createRouteBuilderEndpointsCompleter(builder.getUIContext(), currentFile::equals);
            boolean found = false;
            if (cursorLineNumber != -1) {
                LOG.info("Cursor line " + cursorLineNumber);
                for (CamelEndpointDetails detail : this.javaCompleter.getEndpoints()) {
                    LOG.info("Endpoint candidate: " + detail);
                    if (detail.getLineNumber() == null || Integer.valueOf(detail.getLineNumber()) != cursorLineNumber) continue;
                    this.endpoints.setValue((Object)detail.getEndpointUri());
                    this.endpoints.setRequired(false);
                    found = true;
                    break;
                }
            }
            LOG.info("Found " + found);
            if (!found && !this.javaCompleter.getEndpoints().isEmpty()) {
                List<String> uris = this.javaCompleter.getEndpointUris();
                uris.add(0, "<select>");
                this.endpoints.setValueChoices(uris);
                builder.add(this.endpoints);
            }
        } else if (xmlFile) {
            LOG.info("XML file");
            this.xmlCompleter = this.createXmlEndpointsCompleter(builder.getUIContext(), currentFile::equals);
            boolean found = false;
            if (cursorLineNumber != -1) {
                LOG.info("Cursor line " + cursorLineNumber);
                for (CamelEndpointDetails detail : this.xmlCompleter.getEndpoints()) {
                    LOG.info("Endpoint candidate: " + detail);
                    if (detail.getLineNumber() == null || Integer.valueOf(detail.getLineNumber()) != cursorLineNumber) continue;
                    this.endpoints.setValue((Object)detail.getEndpointUri());
                    this.endpoints.setRequired(false);
                    found = true;
                    break;
                }
            }
            LOG.info("Found " + found);
            if (!found && !this.xmlCompleter.getEndpoints().isEmpty()) {
                List<String> uris = this.xmlCompleter.getEndpointUris();
                uris.add(0, "<select>");
                this.endpoints.setValueChoices((Iterable)uris);
                builder.add(this.endpoints);
            }
        } else {
            this.currentLineCompleter = this.createCurrentLineCompleter(cursorLineNumber, currentFile, builder.getUIContext());
            CamelEndpointDetails detail = this.currentLineCompleter.getEndpoint();
            if (detail != null && detail.getEndpointUri() != null) {
                this.endpoints.setValue((Object)detail.getEndpointUri());
                this.endpoints.setRequired(false);
            }
        }
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        NavigationResult navigationResult;
        Map attributeMap = context.getUIContext().getAttributeMap();
        String selectedUri = (String)this.endpoints.getValue();
        if ("<select>".equals(selectedUri)) {
            attributeMap.remove("navigationResult");
            return null;
        }
        String previous = (String)attributeMap.get("endpointUri");
        if (previous != null && previous.equals(this.endpoints.getValue()) && (navigationResult = (NavigationResult)attributeMap.get("navigationResult")) != null) {
            return navigationResult;
        }
        CamelEndpointDetails detail = null;
        if (this.javaCompleter != null) {
            detail = this.javaCompleter.getEndpointDetail(selectedUri);
        } else if (this.xmlCompleter != null) {
            detail = this.xmlCompleter.getEndpointDetail(selectedUri);
        } else if (this.currentLineCompleter != null) {
            detail = this.currentLineCompleter.getEndpoint();
        }
        LOG.info("Endpoint detail: " + detail);
        if (detail == null) {
            return null;
        }
        attributeMap.put("componentName", detail.getEndpointComponentName());
        attributeMap.put("instanceName", detail.getEndpointInstance());
        attributeMap.put("endpointUri", detail.getEndpointUri());
        attributeMap.put("lineNumber", detail.getLineNumber());
        attributeMap.put("lineNumberEnd", detail.getLineNumberEnd());
        attributeMap.put("mode", "edit");
        if (this.javaCompleter != null) {
            attributeMap.put("routeBuilder", detail.getFileName());
            attributeMap.put("kind", "java");
        } else if (this.xmlCompleter != null) {
            attributeMap.put("xml", detail.getFileName());
            attributeMap.put("kind", "xml");
        } else if (this.currentLineCompleter != null) {
            attributeMap.put("currentFile", detail.getFileName());
            attributeMap.put("kind", "other");
        }
        String camelComponentName = detail.getEndpointComponentName();
        String uri = detail.getEndpointUri();
        String json = this.getCamelCatalog().componentJSonSchema(camelComponentName);
        if (json == null) {
            throw new IllegalArgumentException("Could not find catalog entry for component name: " + camelComponentName);
        }
        LOG.info("Component json: " + json);
        boolean consumerOnly = detail.isConsumerOnly();
        boolean producerOnly = detail.isProducerOnly();
        UIContext ui = context.getUIContext();
        List<InputOptionByGroup> groups = CamelCommandsHelper.createUIInputsForCamelEndpoint(camelComponentName, uri, 20, consumerOnly, producerOnly, this.getCamelCatalog(), this.componentFactory, this.converterFactory, ui);
        ArrayList<InputComponent> allInputs = new ArrayList<InputComponent>();
        for (InputOptionByGroup group : groups) {
            allInputs.addAll(group.getInputs());
        }
        LOG.info(allInputs.size() + " input fields in the UI wizard");
        NavigationResultBuilder builder = Results.navigationBuilder();
        int pages = groups.size();
        for (int i = 0; i < pages; ++i) {
            boolean last = i == pages - 1;
            InputOptionByGroup current = groups.get(i);
            ConfigureEndpointPropertiesStep step = new ConfigureEndpointPropertiesStep(this.projectFactory, this.dependencyInstaller, this.getCamelCatalog(), camelComponentName, current.getGroup(), allInputs, current.getInputs(), last, i, pages);
            builder.add((UICommand)step);
        }
        NavigationResult navigationResult2 = builder.build();
        attributeMap.put("navigationResult", navigationResult2);
        return navigationResult2;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        return null;
    }
}

