/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.completer;

import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import io.fabric8.forge.camel.commands.project.helper.CamelJavaParserHelper;
import io.fabric8.forge.camel.commands.project.model.CamelEndpointDetails;
import java.util.List;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.java.resources.JavaResourceVisitor;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.visit.VisitContext;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public class RouteBuilderCamelEndpointsVisitor
extends JavaResourceVisitor {
    private final JavaSourceFacet facet;
    private final List<CamelEndpointDetails> endpoints;

    public RouteBuilderCamelEndpointsVisitor(JavaSourceFacet facet, List<CamelEndpointDetails> endpoints) {
        this.facet = facet;
        this.endpoints = endpoints;
    }

    public void visit(VisitContext visitContext, JavaResource resource) {
        try {
            CamelEndpointDetails detail;
            JavaClassSource clazz = (JavaClassSource)resource.getJavaType();
            String superType = clazz.getSuperType();
            if (superType != null) {
                boolean valid;
                boolean bl = valid = "org.apache.camel.builder.RouteBuilder".equals(superType) || "org.apache.camel.spring.boot.FatJarRouter".equals(superType);
                if (!valid) {
                    return;
                }
            }
            for (FieldSource field : clazz.getFields()) {
                String uri = null;
                for (Annotation ann : field.getAnnotations()) {
                    if ("org.apache.camel.EndpointInject".equals(ann.getQualifiedName())) {
                        uri = ann.getStringValue();
                        continue;
                    }
                    if (!"org.apache.camel.cdi.Uri".equals(ann.getQualifiedName())) continue;
                    uri = ann.getStringValue();
                }
                if (uri == null || this.findEndpointByUri(uri) != null) continue;
                String baseDir = this.facet.getSourceDirectory().getFullyQualifiedName();
                String fileName = resource.getFullyQualifiedName();
                if (fileName.startsWith(baseDir)) {
                    fileName = fileName.substring(baseDir.length() + 1);
                }
                String id = field.getName();
                detail = new CamelEndpointDetails();
                detail.setResource((Resource)resource);
                detail.setFileName(fileName);
                detail.setEndpointInstance(id);
                detail.setEndpointUri(uri);
                detail.setEndpointComponentName(CamelCatalogHelper.endpointComponentName(uri));
                this.endpoints.add(detail);
            }
            MethodSource<JavaClassSource> method = CamelJavaParserHelper.findConfigureMethod(clazz);
            if (method != null) {
                CamelEndpointDetails detail2;
                List<String> uris = CamelJavaParserHelper.parseCamelConsumerUris(method, false, true);
                for (String uri : uris) {
                    detail2 = this.findEndpointByUri(uri);
                    if (detail2 == null) continue;
                    detail2.setConsumerOnly(true);
                }
                uris = CamelJavaParserHelper.parseCamelProducerUris(method, false, true);
                for (String uri : uris) {
                    detail2 = this.findEndpointByUri(uri);
                    if (detail2 == null) continue;
                    if (detail2.isConsumerOnly()) {
                        detail2.setConsumerOnly(false);
                        detail2.setProducerOnly(false);
                        continue;
                    }
                    detail2.setProducerOnly(true);
                }
                uris = CamelJavaParserHelper.parseCamelConsumerUris(method, true, false);
                for (String uri : uris) {
                    String baseDir = this.facet.getSourceDirectory().getFullyQualifiedName();
                    String fileName = resource.getFullyQualifiedName();
                    if (fileName.startsWith(baseDir)) {
                        fileName = fileName.substring(baseDir.length() + 1);
                    }
                    detail = new CamelEndpointDetails();
                    detail.setResource((Resource)resource);
                    detail.setFileName(fileName);
                    detail.setEndpointInstance(null);
                    detail.setEndpointUri(uri);
                    detail.setEndpointComponentName(CamelCatalogHelper.endpointComponentName(uri));
                    detail.setConsumerOnly(true);
                    detail.setProducerOnly(false);
                    this.endpoints.add(detail);
                }
                uris = CamelJavaParserHelper.parseCamelProducerUris(method, true, false);
                for (String uri : uris) {
                    detail2 = this.findEndpointByUri(uri);
                    if (detail2 == null) {
                        String baseDir = this.facet.getSourceDirectory().getFullyQualifiedName();
                        String fileName = resource.getFullyQualifiedName();
                        if (fileName.startsWith(baseDir)) {
                            fileName = fileName.substring(baseDir.length() + 1);
                        }
                        detail2 = new CamelEndpointDetails();
                        detail2.setResource((Resource)resource);
                        detail2.setFileName(fileName);
                        detail2.setEndpointInstance(null);
                        detail2.setEndpointUri(uri);
                        detail2.setEndpointComponentName(CamelCatalogHelper.endpointComponentName(uri));
                        detail2.setConsumerOnly(false);
                        detail2.setProducerOnly(true);
                        this.endpoints.add(detail2);
                        continue;
                    }
                    detail2.setConsumerOnly(false);
                    detail2.setProducerOnly(false);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private CamelEndpointDetails findEndpointByUri(String uri) {
        for (CamelEndpointDetails detail : this.endpoints) {
            if (!uri.equals(detail.getEndpointUri())) continue;
            return detail;
        }
        return null;
    }
}

