/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.dto.ComponentDto;
import io.fabric8.forge.camel.commands.project.dto.OutputFormat;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import io.fabric8.forge.camel.commands.project.helper.OutputFormatHelper;
import io.fabric8.utils.TablePrinter;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class CamelGetAvailableComponentsCommand
extends AbstractCamelProjectCommand {
    @Inject
    @WithAttributes(label="Filter", required=false, description="To filter components")
    private UISelectOne<String> filter;
    @Inject
    @WithAttributes(label="Name", defaultValue="Text", description="Name of dataformat to add")
    private UISelectOne<OutputFormat> format;
    @Inject
    @WithAttributes(label="Verbose", defaultValue="false", description="Whether to use verbose text output")
    private UIInput<Boolean> verbose;
    @Inject
    @WithAttributes(label="Exclude Project", defaultValue="true", description="Whether to exclude components in the current project")
    private UIInput<Boolean> excludeProject;
    @Inject
    private DependencyInstaller dependencyInstaller;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelGetAvailableComponentsCommand.class).name("Camel: Get Components").category(Categories.create((String[])new String[]{CATEGORY})).description("Gets the components available in the camel catalog and/or in the current project");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)builder);
        this.filter.setValueChoices(CamelCommandsHelper.createComponentLabelValues(project, this.getCamelCatalog()));
        this.filter.setDefaultValue((Object)"<all>");
        builder.add(this.filter).add(this.format).add(this.verbose);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)context);
        Callable<Iterable<ComponentDto>> callable = CamelCommandsHelper.createComponentDtoValues(project, this.getCamelCatalog(), this.filter, CamelGetAvailableComponentsCommand.isValueTrue(this.excludeProject));
        Iterable<ComponentDto> results = callable.call();
        String result = this.formatResult(results);
        return Results.success((String)result);
    }

    protected String formatResult(Iterable<ComponentDto> results) throws JsonProcessingException {
        OutputFormat outputFormat = (OutputFormat)((Object)this.format.getValue());
        switch (outputFormat) {
            case JSON: {
                return OutputFormatHelper.toJson(results);
            }
        }
        return this.textResult(results);
    }

    protected String textResult(Iterable<ComponentDto> components) {
        StringBuilder buffer = new StringBuilder();
        TablePrinter table = new TablePrinter();
        if (CamelGetAvailableComponentsCommand.isValueTrue(this.verbose)) {
            table.columns(new String[]{"name", "description", "tags", "syntax", "artifact"});
            for (ComponentDto component : components) {
                table.row(new String[]{component.getScheme(), component.getDescription(), component.getLabel(), component.getSyntax(), component.getGroupId() + ":" + component.getArtifactId() + ":" + component.getVersion()});
            }
        } else {
            table.columns(new String[]{"name", "description"});
            for (ComponentDto component : components) {
                table.row(new String[]{component.getScheme(), component.getDescription()});
            }
        }
        OutputFormatHelper.addTableTextOutput(buffer, "Components", table);
        return buffer.toString();
    }

    protected static boolean isValueTrue(UIInput<Boolean> value) {
        Boolean verboseValue = (Boolean)value.getValue();
        return verboseValue != null && verboseValue != false;
    }
}

