/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.ConfigureEndpointPropertiesStep;
import io.fabric8.forge.camel.commands.project.completer.XmlEndpointsCompleter;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import io.fabric8.forge.camel.commands.project.model.CamelEndpointDetails;
import io.fabric8.forge.camel.commands.project.model.EndpointOptionByGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultBuilder;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;

public class CamelEditEndpointXmlCommand
extends AbstractCamelProjectCommand
implements UIWizard {
    private static final int MAX_OPTIONS = 20;
    @Inject
    @WithAttributes(label="Endpoints", required=true, description="The endpoints from the project")
    private UISelectOne<String> endpoints;
    @Inject
    private InputComponentFactory componentFactory;
    @Inject
    private DependencyInstaller dependencyInstaller;
    private XmlEndpointsCompleter completer;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelEditEndpointXmlCommand.class).name("Camel: Edit Endpoint XML").category(Categories.create((String[])new String[]{CATEGORY})).description("Edit Camel endpoint from an existing XML file");
    }

    @Override
    public boolean isEnabled(UIContext context) {
        boolean enabled = super.isEnabled(context);
        if (enabled) {
            boolean spring = CamelCommandsHelper.isSpringProject(this.getSelectedProject(context));
            boolean blueprint = CamelCommandsHelper.isBlueprintProject(this.getSelectedProject(context));
            return spring || blueprint;
        }
        return false;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Map attributeMap = builder.getUIContext().getAttributeMap();
        attributeMap.remove("navigationResult");
        Project project = this.getSelectedProject(builder.getUIContext());
        ResourcesFacet resourcesFacet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        WebResourcesFacet webResourcesFacet = null;
        if (project.hasFacet(WebResourcesFacet.class)) {
            webResourcesFacet = (WebResourcesFacet)project.getFacet(WebResourcesFacet.class);
        }
        this.completer = new XmlEndpointsCompleter(resourcesFacet, webResourcesFacet);
        List<String> uris = this.completer.getEndpointUris();
        uris.add(0, "<select>");
        this.endpoints.setValueChoices(uris);
        builder.add(this.endpoints);
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        NavigationResult navigationResult;
        Map attributeMap = context.getUIContext().getAttributeMap();
        String selectedUri = (String)this.endpoints.getValue();
        if ("<select>".equals(selectedUri)) {
            attributeMap.remove("navigationResult");
            return null;
        }
        String previous = (String)attributeMap.get("endpointUri");
        if (previous != null && previous.equals(this.endpoints.getValue()) && (navigationResult = (NavigationResult)attributeMap.get("navigationResult")) != null) {
            return navigationResult;
        }
        CamelEndpointDetails detail = this.completer.getEndpointDetail(selectedUri);
        if (detail == null) {
            return null;
        }
        attributeMap.put("componentName", detail.getEndpointComponentName());
        attributeMap.put("instanceName", detail.getEndpointInstance());
        attributeMap.put("endpointUri", detail.getEndpointUri());
        attributeMap.put("lineNumber", detail.getLineNumber());
        attributeMap.put("xml", detail.getFileName());
        attributeMap.put("mode", "edit");
        attributeMap.put("kind", "xml");
        String camelComponentName = detail.getEndpointComponentName();
        String uri = detail.getEndpointUri();
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        String json = catalog.componentJSonSchema(camelComponentName);
        if (json == null) {
            throw new IllegalArgumentException("Could not find catalog entry for component name: " + camelComponentName);
        }
        boolean consumerOnly = detail.isConsumerOnly();
        boolean producerOnly = detail.isProducerOnly();
        UIContext ui = context.getUIContext();
        List<EndpointOptionByGroup> groups = CamelCommandsHelper.createUIInputsForCamelComponent(camelComponentName, uri, 20, consumerOnly, producerOnly, this.componentFactory, this.converterFactory, ui);
        ArrayList<InputComponent> allInputs = new ArrayList<InputComponent>();
        for (EndpointOptionByGroup group : groups) {
            allInputs.addAll(group.getInputs());
        }
        NavigationResultBuilder builder = Results.navigationBuilder();
        int pages = groups.size();
        for (int i = 0; i < pages; ++i) {
            boolean last = i == pages - 1;
            EndpointOptionByGroup current = groups.get(i);
            ConfigureEndpointPropertiesStep step = new ConfigureEndpointPropertiesStep(this.projectFactory, this.dependencyInstaller, camelComponentName, current.getGroup(), allInputs, current.getInputs(), last, i, pages);
            builder.add((UICommand)step);
        }
        NavigationResult navigationResult2 = builder.build();
        attributeMap.put("navigationResult", navigationResult2);
        return navigationResult2;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        boolean empty;
        boolean bl = empty = !this.endpoints.getValueChoices().iterator().hasNext();
        if (empty) {
            return Results.fail((String)"No Camel endpoints found");
        }
        return Results.success();
    }
}

