/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Expression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ExpressionStatement;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MethodDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MethodInvocation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.StringLiteral;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public class CamelJavaParserHelper {
    public static MethodSource<JavaClassSource> findConfigureMethod(JavaClassSource clazz) {
        MethodSource method = clazz.getMethod("configure");
        if (method != null && method.isPublic() && method.getParameters().isEmpty() && method.getReturnType().isType("void")) {
            return method;
        }
        return null;
    }

    public static List<String> parseCamelConsumerUris(MethodSource<JavaClassSource> method) {
        return CamelJavaParserHelper.parseCamelUris(method, true, false);
    }

    public static List<String> parseCamelProducerUris(MethodSource<JavaClassSource> method) {
        return CamelJavaParserHelper.parseCamelUris(method, false, true);
    }

    public static List<String> parseCamelUris(MethodSource<JavaClassSource> method, boolean consumers, boolean producers) {
        ArrayList<String> answer = new ArrayList<String>();
        MethodDeclaration md = (MethodDeclaration)method.getInternal();
        for (Object statement : md.getBody().statements()) {
            if (!(statement instanceof ExpressionStatement)) continue;
            ExpressionStatement es = (ExpressionStatement)statement;
            Expression exp = es.getExpression();
            ArrayList<String> uris = new ArrayList<String>();
            CamelJavaParserHelper.parseExpression(exp, uris, consumers, producers);
            if (uris.isEmpty()) continue;
            Collections.reverse(uris);
            answer.addAll(uris);
        }
        return answer;
    }

    private static void parseExpression(Expression exp, List<String> uris, boolean consumers, boolean producers) {
        if (exp == null) {
            return;
        }
        if (exp instanceof MethodInvocation) {
            MethodInvocation mi = (MethodInvocation)exp;
            CamelJavaParserHelper.parseCamelUris(mi, uris, consumers, producers);
            exp = mi.getExpression();
            CamelJavaParserHelper.parseExpression(exp, uris, consumers, producers);
        }
    }

    private static void parseCamelUris(MethodInvocation mi, List<String> uris, boolean consumers, boolean producers) {
        String uri;
        Iterator arg;
        String uri2;
        List args;
        String name = mi.getName().getIdentifier();
        if (consumers) {
            if ("from".equals(name) && (args = mi.arguments()) != null) {
                for (Object arg2 : args) {
                    if (!(arg2 instanceof StringLiteral)) continue;
                    uri2 = ((StringLiteral)arg2).getLiteralValue();
                    uris.add(uri2);
                }
            }
            if ("pollEnrich".equals(name) && (args = mi.arguments()) != null && args.size() >= 1 && (arg = args.get(0)) instanceof StringLiteral) {
                uri = ((StringLiteral)arg).getLiteralValue();
                uris.add(uri);
            }
        }
        if (producers) {
            if (("to".equals(name) || "toD".equals(name)) && (args = mi.arguments()) != null) {
                arg = args.iterator();
                while (arg.hasNext()) {
                    Object arg2;
                    arg2 = arg.next();
                    if (!(arg2 instanceof StringLiteral)) continue;
                    uri2 = ((StringLiteral)arg2).getLiteralValue();
                    uris.add(uri2);
                }
            }
            if (("enrich".equals(name) || "wireTap".equals(name)) && (args = mi.arguments()) != null && args.size() >= 1 && (arg = args.get(0)) instanceof StringLiteral) {
                uri = ((StringLiteral)arg).getLiteralValue();
                uris.add(uri);
            }
        }
    }
}

