/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.completer;

import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import io.fabric8.forge.camel.commands.project.model.CamelEndpointDetails;
import java.util.List;
import org.apache.camel.builder.RouteBuilder;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.java.resources.JavaResourceVisitor;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.visit.VisitContext;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;

public class RouteBuilderCamelEndpointsVisitor
extends JavaResourceVisitor {
    private final JavaSourceFacet facet;
    private final List<CamelEndpointDetails> endpoints;

    public RouteBuilderCamelEndpointsVisitor(JavaSourceFacet facet, List<CamelEndpointDetails> endpoints) {
        this.facet = facet;
        this.endpoints = endpoints;
    }

    public void visit(VisitContext visitContext, JavaResource resource) {
        try {
            JavaClassSource clazz = (JavaClassSource)resource.getJavaType();
            String superType = clazz.getSuperType();
            if (superType != null && !RouteBuilder.class.getName().equals(superType)) {
                return;
            }
            for (FieldSource field : clazz.getFields()) {
                String uri = null;
                for (Annotation ann : field.getAnnotations()) {
                    if ("org.apache.camel.EndpointInject".equals(ann.getQualifiedName())) {
                        uri = ann.getStringValue();
                        continue;
                    }
                    if (!"org.apache.camel.cdi.Uri".equals(ann.getQualifiedName())) continue;
                    uri = ann.getStringValue();
                }
                if (uri == null) continue;
                String baseDir = this.facet.getSourceDirectory().getFullyQualifiedName();
                String fileName = resource.getFullyQualifiedName();
                if (fileName.startsWith(baseDir)) {
                    fileName = fileName.substring(baseDir.length() + 1);
                }
                String id = field.getName();
                CamelEndpointDetails detail = new CamelEndpointDetails();
                detail.setResource((Resource)resource);
                detail.setFileName(fileName);
                detail.setEndpointInstance(id);
                detail.setEndpointUri(uri);
                detail.setEndpointComponentName(CamelCatalogHelper.endpointComponentName(uri));
                this.endpoints.add(detail);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

