/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.ConfigureEndpointPropertiesStep;
import io.fabric8.forge.camel.commands.project.completer.RouteBuilderEndpointsCompleter;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import io.fabric8.forge.camel.commands.project.model.CamelEndpointDetails;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultBuilder;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;

public class CamelEditEndpointCommand
extends AbstractCamelProjectCommand
implements UIWizard {
    private static final int MAX_OPTIONS = 15;
    @Inject
    @WithAttributes(label="Endpoints", required=true, description="The endpoints from the project")
    private UISelectOne<String> endpoints;
    @Inject
    private InputComponentFactory componentFactory;
    @Inject
    private DependencyInstaller dependencyInstaller;
    private RouteBuilderEndpointsCompleter completer;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelEditEndpointCommand.class).name("Camel: Edit Endpoint").category(Categories.create((String[])new String[]{CATEGORY})).description("Edit Camel endpoint from an existing RouteBuilder class");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Map attributeMap = builder.getUIContext().getAttributeMap();
        attributeMap.remove("navigationResult");
        Project project = this.getSelectedProject(builder.getUIContext());
        JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        this.completer = new RouteBuilderEndpointsCompleter(facet);
        this.endpoints.setValueChoices(this.completer.getEndpointUris());
        builder.add(this.endpoints);
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        NavigationResult navigationResult;
        Map attributeMap = context.getUIContext().getAttributeMap();
        String previous = (String)attributeMap.get("endpointUri");
        if (previous != null && previous.equals(this.endpoints.getValue()) && (navigationResult = (NavigationResult)attributeMap.get("navigationResult")) != null) {
            return navigationResult;
        }
        String selectedUri = (String)this.endpoints.getValue();
        CamelEndpointDetails detail = this.completer.getEndpointDetail(selectedUri);
        if (detail == null) {
            return null;
        }
        attributeMap.put("componentName", detail.getEndpointComponentName());
        attributeMap.put("instanceName", detail.getEndpointInstance());
        attributeMap.put("endpointUri", detail.getEndpointUri());
        attributeMap.put("lineNumber", detail.getLineNumber());
        attributeMap.put("routeBuilder", detail.getFileName());
        attributeMap.put("mode", "edit");
        attributeMap.put("kind", "java");
        String camelComponentName = detail.getEndpointComponentName();
        String uri = detail.getEndpointUri();
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        String json = catalog.componentJSonSchema(camelComponentName);
        if (json == null) {
            throw new IllegalArgumentException("Could not find catalog entry for component name: " + camelComponentName);
        }
        List<InputComponent> allInputs = CamelCommandsHelper.createUIInputsForCamelComponent(camelComponentName, uri, this.componentFactory, this.converterFactory);
        int size = allInputs.size();
        NavigationResultBuilder builder = Results.navigationBuilder();
        int pages = size % 15 == 0 ? size / 15 : size / 15 + 1;
        for (int i = 0; i < pages; ++i) {
            int from = i * 15;
            int delta = Math.min(15, size - from);
            int to = from + delta;
            boolean last = i == pages - 1;
            List<InputComponent> inputs = allInputs.subList(from, to);
            ConfigureEndpointPropertiesStep step = new ConfigureEndpointPropertiesStep(this.projectFactory, this.dependencyInstaller, camelComponentName, allInputs, inputs, last, i, pages);
            builder.add((UICommand)step);
        }
        NavigationResult navigationResult2 = builder.build();
        attributeMap.put("navigationResult", navigationResult2);
        return navigationResult2;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        boolean empty;
        boolean bl = empty = !this.endpoints.getValueChoices().iterator().hasNext();
        if (empty) {
            return Results.fail((String)"No Camel endpoints found");
        }
        return Results.success();
    }
}

