/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.addon.utils.VersionHelper;
import io.fabric8.forge.camel.commands.jolokia.ConnectCommand;
import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import java.util.Arrays;
import java.util.Set;
import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.maven.plugins.MavenPlugin;
import org.jboss.forge.addon.maven.plugins.MavenPluginBuilder;
import org.jboss.forge.addon.maven.projects.MavenPluginFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class CamelSetupCommand
extends AbstractCamelProjectCommand {
    private String[] choices = new String[]{"camel-core", "camel-blueprint", "camel-cdi", "camel-spring", "camel-spring-boot"};
    @Inject
    @WithAttributes(label="kind", required=true, description="Camel project kind.")
    private UISelectOne<String> kind;
    @Inject
    @WithAttributes(label="version", required=false, description="Camel version to use. If none provided then the latest version will be used.")
    private UIInput<String> version;
    @Inject
    private DependencyInstaller dependencyInstaller;

    @Override
    public boolean isEnabled(UIContext context) {
        Project project = this.getSelectedProjectOrNull(context);
        return project != null;
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(ConnectCommand.class).name("Camel: Setup").category(Categories.create((String[])new String[]{CATEGORY})).description("Setup Apache Camel in your project");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.kind.setValueChoices(Arrays.asList(this.choices));
        builder.add(this.kind).add(this.version);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)context);
        Dependency core = this.findCamelCoreDependency(project);
        if (core != null) {
            return Results.success((String)"Apache Camel is already setup");
        }
        core = DependencyBuilder.create().setCoordinate(this.createCamelCoordinate("camel-core", (String)this.version.getValue()));
        this.dependencyInstaller.install(project, core);
        core = this.findCamelCoreDependency(project);
        String camelVersion = core.getCoordinate().getVersion();
        boolean found = false;
        Set<Dependency> existing = this.findCamelArtifacts(project);
        for (Dependency dependency : existing) {
            if (!dependency.getCoordinate().getArtifactId().equals(this.kind.getValue())) continue;
            found = true;
            break;
        }
        if (!found) {
            DependencyBuilder testComponent;
            DependencyBuilder component = DependencyBuilder.create().setGroupId("org.apache.camel").setArtifactId((String)this.kind.getValue()).setVersion(core.getCoordinate().getVersion());
            this.dependencyInstaller.install(project, (Dependency)component);
            if ("camel-core".equals(this.kind.getValue())) {
                testComponent = DependencyBuilder.create().setGroupId("org.apache.camel").setArtifactId("camel-test").setVersion(core.getCoordinate().getVersion()).setScopeType("test");
                this.dependencyInstaller.install(project, (Dependency)testComponent);
            } else if ("camel-spring".equals(this.kind.getValue()) || "camel-spring-boot".equals(this.kind.getValue())) {
                testComponent = DependencyBuilder.create().setGroupId("org.apache.camel").setArtifactId("camel-test-spring").setVersion(core.getCoordinate().getVersion()).setScopeType("test");
                this.dependencyInstaller.install(project, (Dependency)testComponent);
            } else if ("camel-blueprint".equals(this.kind.getValue())) {
                testComponent = DependencyBuilder.create().setGroupId("org.apache.camel").setArtifactId("camel-test-blueprint").setVersion(core.getCoordinate().getVersion()).setScopeType("test");
                this.dependencyInstaller.install(project, (Dependency)testComponent);
            }
        }
        MavenPluginFacet pluginFacet = (MavenPluginFacet)project.getFacet(MavenPluginFacet.class);
        MavenPluginBuilder plugin = MavenPluginBuilder.create().setCoordinate(this.createCamelCoordinate("camel-maven-plugin", camelVersion));
        pluginFacet.addPlugin((MavenPlugin)plugin);
        plugin = MavenPluginBuilder.create().setCoordinate(this.createCoordinate("io.hawt", "hawtio-maven-plugin", VersionHelper.hawtioVersion()));
        pluginFacet.addPlugin((MavenPlugin)plugin);
        return Results.success((String)"Added Apache Camel to the project");
    }
}

