/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.completer;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import org.apache.camel.builder.RouteBuilder;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.java.resources.JavaResourceVisitor;
import org.jboss.forge.addon.resource.visit.VisitContext;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.roaster.model.JavaClass;

public class RouteBuilderCompleter
implements UICompleter<String> {
    private final Set<String> routeBuilders = new TreeSet<String>();

    public RouteBuilderCompleter(JavaSourceFacet facet) {
        facet.visitJavaSources(new JavaResourceVisitor(){

            public void visit(VisitContext context, JavaResource javaResource) {
                try {
                    JavaClass clazz = (JavaClass)javaResource.getJavaType();
                    String superType = clazz.getSuperType();
                    if (superType != null && RouteBuilder.class.getName().equals(superType)) {
                        RouteBuilderCompleter.this.routeBuilders.add(clazz.getQualifiedName());
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        });
    }

    public Set<String> getRouteBuilders() {
        return this.routeBuilders;
    }

    public Iterable<String> getCompletionProposals(UIContext context, InputComponent input, String value) {
        ArrayList<String> answer = new ArrayList<String>();
        for (String name : this.routeBuilders) {
            if (value != null && !name.startsWith(value)) continue;
            answer.add(name);
        }
        return answer;
    }
}

