/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.addon.utils.completer.PackageNameCompleter;
import io.fabric8.forge.addon.utils.validator.ClassNameValidator;
import io.fabric8.forge.addon.utils.validator.PackageNameValidator;
import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.completer.RouteBuilderCompleter;
import io.fabric8.forge.camel.commands.project.helper.CollectionHelper;
import java.util.Set;
import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.facets.HintsFacet;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.validate.UIValidator;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodSource;

@FacetConstraint(value={JavaSourceFacet.class, ResourcesFacet.class})
public class CamelNewRouteBuilderCommand
extends AbstractCamelProjectCommand {
    @Inject
    @WithAttributes(label="Target Package", required=true, description="The package name where this type will be created")
    private UIInput<String> targetPackage;
    @Inject
    @WithAttributes(label="Class Name", required=true, description="Name of RouteBuilder class")
    private UIInput<String> name;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelNewRouteBuilderCommand.class).name("Camel: New RouteBuilder").category(Categories.create((String[])new String[]{CATEGORY})).description("Creates a new Camel Java RouteBuilder class");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = this.getSelectedProject(builder.getUIContext());
        JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        this.targetPackage.setCompleter((UICompleter)new PackageNameCompleter(facet));
        this.targetPackage.addValidator((UIValidator)new PackageNameValidator());
        ((HintsFacet)this.targetPackage.getFacet(HintsFacet.class)).setInputType("org.jboss.forge.inputType.JAVA_PACKAGE_PICKER");
        Set<String> packages = new RouteBuilderCompleter(facet).getPackages();
        if (packages.size() == 1) {
            this.targetPackage.setDefaultValue((Object)CollectionHelper.first(packages));
        }
        this.name.addValidator((UIValidator)new ClassNameValidator(false));
        ((HintsFacet)this.name.getFacet(HintsFacet.class)).setInputType("org.jboss.forge.inputType.JAVA_CLASS_PICKER");
        builder.add(this.targetPackage).add(this.name);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)context);
        JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        Dependency core = this.findCamelCoreDependency(project);
        if (core == null) {
            return Results.fail((String)"The project does not include camel-core");
        }
        String fqn = this.targetPackage.getValue() != null ? (String)this.targetPackage.getValue() + "." + (String)this.name.getValue() : (String)this.name.getValue();
        JavaResource existing = facet.getJavaResource(fqn);
        if (existing != null && existing.exists()) {
            return Results.fail((String)("A class with name " + fqn + " already exists"));
        }
        JavaClassSource javaClass = (JavaClassSource)Roaster.create(JavaClassSource.class);
        javaClass.setName((String)this.name.getValue());
        if (this.targetPackage.getValue() != null) {
            javaClass.setPackage((String)this.targetPackage.getValue());
        }
        javaClass.setSuperType("RouteBuilder");
        javaClass.addImport("org.apache.camel.builder.RouteBuilder");
        ((MethodSource)((MethodSource)javaClass.addMethod().setPublic()).setReturnTypeVoid().setName("configure")).addThrows(Exception.class).setBody("");
        facet.saveJavaSource((JavaSource)javaClass);
        return Results.success((String)("Created new RouteBuilder class " + (String)this.name.getValue()));
    }
}

