/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.addon.utils.LineNumberHelper;
import io.fabric8.forge.addon.utils.XmlLineNumberParser;
import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.dto.ContextDto;
import io.fabric8.forge.camel.commands.project.dto.NodeDto;
import io.fabric8.forge.camel.commands.project.dto.NodeDtoSupport;
import io.fabric8.forge.camel.commands.project.helper.CamelXmlHelper;
import io.fabric8.utils.Strings;
import java.io.InputStream;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CamelDeleteNodeXmlCommand
extends AbstractCamelProjectCommand {
    @Inject
    @WithAttributes(label="XML File", required=true, description="The XML file to use (either Spring or Blueprint)")
    private UISelectOne<String> xml;
    @Inject
    @WithAttributes(label="Node", required=true, description="Node to delete")
    private UISelectOne<String> node;
    private transient List<NodeDto> nodes;

    @Override
    public boolean isEnabled(UIContext context) {
        boolean enabled = super.isEnabled(context);
        if (enabled) {
            String currentFile;
            Project project = this.getSelectedProject(context);
            String selected = this.configureXml(project, this.xml, currentFile = this.getSelectedFile(context));
            return selected != null;
        }
        return false;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        UIContext context = builder.getUIContext();
        Project project = this.getSelectedProject(context);
        String currentFile = this.getSelectedFile(context);
        String selected = this.configureXml(project, this.xml, currentFile);
        this.nodes = this.configureXmlNodes(context, project, selected, this.xml, this.node);
        builder.add(this.xml).add(this.node);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)context);
        NodeDtoSupport nodeValue = null;
        int selectedIdx = this.node.getSelectedIndex();
        if (selectedIdx != -1) {
            nodeValue = this.nodes.get(selectedIdx);
        }
        if (nodeValue == null) {
            return Results.fail((String)"No node to delete!");
        }
        String key = nodeValue.getKey();
        if (Strings.isNullOrBlank((String)key)) {
            return Results.fail((String)"Selected node does not have a key so cannot delete it!");
        }
        String xmlResourceName = (String)this.xml.getValue();
        FileResource file = this.getXmlResourceFile(project, xmlResourceName);
        if (file == null || !file.exists()) {
            return Results.fail((String)("Cannot find XML file " + xmlResourceName));
        }
        List<ContextDto> camelContexts = CamelXmlHelper.loadCamelContext(this.getCamelCatalog(), context.getUIContext(), project, xmlResourceName);
        if (camelContexts == null) {
            return Results.fail((String)("No file found for: " + xmlResourceName));
        }
        Document root = XmlLineNumberParser.parseXml((InputStream)file.getResourceInputStream());
        if (root != null) {
            Node selectedNode = CamelXmlHelper.findCamelNodeInDocument(root, key);
            if (selectedNode != null) {
                String lineNumber = (String)selectedNode.getUserData("lineNumber");
                String lineNumberEnd = (String)selectedNode.getUserData("lineNumberEnd");
                if (lineNumber != null && lineNumberEnd != null) {
                    List lines = LineNumberHelper.readLines((InputStream)file.getResourceInputStream());
                    int idx = Integer.valueOf(lineNumber) - 1;
                    int idx2 = Integer.valueOf(lineNumberEnd) - 1;
                    for (int delta = idx2 - idx + 1; delta > 0; --delta) {
                        lines.remove(idx);
                    }
                    String content = LineNumberHelper.linesToString((List)lines);
                    file.setContents(content);
                    return Results.success((String)"Removed node");
                }
            }
            return Results.fail((String)("Cannot find Camel node in XML file: " + nodeValue));
        }
        return Results.fail((String)("Cannot load Camel XML file: " + file.getName()));
    }
}

