/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.completer;

import io.fabric8.forge.camel.commands.project.helper.XmlRouteParser;
import io.fabric8.forge.camel.commands.project.model.CamelEndpointDetails;
import java.io.InputStream;
import java.util.List;
import java.util.function.Function;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.visit.ResourceVisitor;
import org.jboss.forge.addon.resource.visit.VisitContext;

public class XmlResourcesCamelEndpointsVisitor
implements ResourceVisitor {
    private final ResourcesFacet facet;
    private final List<CamelEndpointDetails> endpoints;
    private final Function<String, Boolean> filter;

    public XmlResourcesCamelEndpointsVisitor(ResourcesFacet facet, List<CamelEndpointDetails> endpoints, Function<String, Boolean> filter) {
        this.facet = facet;
        this.endpoints = endpoints;
        this.filter = filter;
    }

    public void visit(VisitContext visitContext, Resource<?> resource) {
        String name = resource.getName();
        if (name.endsWith(".xml")) {
            boolean camel;
            boolean include = true;
            if (this.filter != null) {
                String fqn = resource.getFullyQualifiedName();
                Boolean out = this.filter.apply(fqn);
                boolean bl = include = out == null || out != false;
            }
            if (include && (camel = resource.getContents().contains("<camelContext"))) {
                try {
                    InputStream is = resource.getResourceInputStream();
                    String fqn = resource.getFullyQualifiedName();
                    String baseDir = this.facet.getResourceDirectory().getFullyQualifiedName();
                    XmlRouteParser.parseXmlRouteEndpoints(is, baseDir, fqn, this.endpoints);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

