/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.dto.ComponentDto;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import java.util.LinkedHashMap;
import org.apache.camel.catalog.CamelCatalog;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.input.ValueChangeListener;
import org.jboss.forge.addon.ui.input.events.ValueChangeEvent;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;

public class CamelProjectAddComponentStep
extends AbstractCamelProjectCommand
implements UIWizardStep {
    private final UISelectOne<String> filter;
    private final UISelectOne<ComponentDto> componentName;
    private final DependencyInstaller dependencyInstaller;

    public CamelProjectAddComponentStep(UISelectOne<String> filter, UISelectOne<ComponentDto> componentName, ProjectFactory projectFactory, DependencyInstaller dependencyInstaller, CamelCatalog camelCatalog) {
        this.filter = filter;
        this.componentName = componentName;
        this.projectFactory = projectFactory;
        this.dependencyInstaller = dependencyInstaller;
        this.camelCatalog = camelCatalog;
    }

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelProjectAddComponentStep.class).name("Camel: Project Add Component").category(Categories.create((String[])new String[]{CATEGORY})).description("Adds a Camel component to your project dependencies");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)builder);
        Iterable<ComponentDto> it = CamelCommandsHelper.createAllComponentDtoValues(project, this.getCamelCatalog(), this.filter, true).call();
        final LinkedHashMap<String, ComponentDto> components = new LinkedHashMap<String, ComponentDto>();
        for (ComponentDto dto : it) {
            components.put(dto.getScheme(), dto);
        }
        this.componentName.setValueChoices(components.values());
        this.componentName.setValueConverter((Converter)new Converter<String, ComponentDto>(){

            public ComponentDto convert(String text) {
                return (ComponentDto)components.get(text);
            }
        });
        this.componentName.addValueChangeListener(new ValueChangeListener(){

            public void valueChanged(ValueChangeEvent event) {
                ComponentDto component = (ComponentDto)event.getNewValue();
                if (component != null) {
                    String description = component.getDescription();
                    CamelProjectAddComponentStep.this.componentName.setNote(description != null ? description : "");
                } else {
                    CamelProjectAddComponentStep.this.componentName.setNote("");
                }
            }
        });
        builder.add(this.componentName);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)context);
        Dependency core = this.findCamelCoreDependency(project);
        if (core == null) {
            return Results.fail((String)"The project does not include camel-core");
        }
        ComponentDto dto = (ComponentDto)this.componentName.getValue();
        if (dto != null) {
            String version = "org.apache.camel".equals(dto.getGroupId()) ? core.getCoordinate().getVersion() : dto.getVersion();
            DependencyBuilder component = DependencyBuilder.create().setGroupId(dto.getGroupId()).setArtifactId(dto.getArtifactId()).setVersion(version);
            this.dependencyInstaller.install(project, (Dependency)component);
            return Results.success((String)("Added Camel component " + dto.getScheme() + " (" + dto.getArtifactId() + ") to the project"));
        }
        return Results.fail((String)"Unknown Camel component");
    }
}

