/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.completer;

import io.fabric8.forge.camel.commands.project.helper.RouteBuilderParser;
import io.fabric8.forge.camel.commands.project.model.CamelEndpointDetails;
import java.util.List;
import java.util.function.Function;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.java.resources.JavaResourceVisitor;
import org.jboss.forge.addon.resource.visit.VisitContext;
import org.jboss.forge.roaster.model.source.JavaClassSource;

public class RouteBuilderCamelEndpointsVisitor
extends JavaResourceVisitor {
    private final JavaSourceFacet facet;
    private final List<CamelEndpointDetails> endpoints;
    private final Function<String, Boolean> filter;

    public RouteBuilderCamelEndpointsVisitor(JavaSourceFacet facet, List<CamelEndpointDetails> endpoints, Function<String, Boolean> filter) {
        this.facet = facet;
        this.endpoints = endpoints;
        this.filter = filter;
    }

    public void visit(VisitContext visitContext, JavaResource resource) {
        try {
            JavaClassSource clazz = (JavaClassSource)resource.getJavaType();
            String fqn = resource.getFullyQualifiedName();
            String name = clazz.getQualifiedName();
            String baseDir = this.facet.getSourceDirectory().getFullyQualifiedName();
            boolean include = true;
            if (this.filter != null) {
                Boolean out = this.filter.apply(name);
                boolean bl = include = out == null || out != false;
            }
            if (include) {
                RouteBuilderParser.parseRouteBuilderEndpoints(clazz, baseDir, fqn, this.endpoints);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

