/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.ConfigureEndpointPropertiesStep;
import io.fabric8.forge.camel.commands.project.dto.ComponentDto;
import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import io.fabric8.forge.camel.commands.project.model.InputOptionByGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.input.ValueChangeListener;
import org.jboss.forge.addon.ui.input.events.ValueChangeEvent;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultBuilder;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;

public class CamelAddEndpointCommand
extends AbstractCamelProjectCommand
implements UIWizard {
    private static final int MAX_OPTIONS = 20;
    @Inject
    @WithAttributes(label="Filter", required=false, description="To filter components")
    private UISelectOne<String> componentNameFilter;
    @Inject
    @WithAttributes(label="Name", required=true, description="Name of component to use for the endpoint")
    private UISelectOne<ComponentDto> componentName;
    @Inject
    private InputComponentFactory componentFactory;
    @Inject
    private DependencyInstaller dependencyInstaller;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelAddEndpointCommand.class).name("Camel: Add Endpoint").category(Categories.create((String[])new String[]{CATEGORY})).description("Add Camel endpoint to the current file");
    }

    @Override
    public boolean isEnabled(UIContext context) {
        boolean answer = super.isEnabled(context);
        if (answer) {
            int pos = this.getCurrentCursorPosition(context);
            answer = pos > -1;
        }
        return answer;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Map attributeMap = builder.getUIContext().getAttributeMap();
        attributeMap.remove("navigationResult");
        Project project = this.getSelectedProject(builder.getUIContext());
        String selectedFile = this.getSelectedFile(builder.getUIContext());
        String currentFile = this.asRelativeFile(builder.getUIContext(), selectedFile);
        attributeMap.put("currentFile", currentFile);
        this.componentNameFilter.setValueChoices(CamelCommandsHelper.createComponentLabelValues(project, this.getCamelCatalog()));
        this.componentNameFilter.setDefaultValue((Object)"<all>");
        this.componentName.setValueChoices(CamelCommandsHelper.createComponentDtoValues(project, this.getCamelCatalog(), this.componentNameFilter, false));
        this.componentName.setValueConverter((Converter)new Converter<String, ComponentDto>(){

            public ComponentDto convert(String text) {
                return CamelCatalogHelper.createComponentDto(CamelAddEndpointCommand.this.getCamelCatalog(), text);
            }
        });
        this.componentName.addValueChangeListener(new ValueChangeListener(){

            public void valueChanged(ValueChangeEvent event) {
                ComponentDto component = (ComponentDto)event.getNewValue();
                if (component != null) {
                    String description = component.getDescription();
                    CamelAddEndpointCommand.this.componentName.setNote(description != null ? description : "");
                } else {
                    CamelAddEndpointCommand.this.componentName.setNote("");
                }
            }
        });
        builder.add(this.componentNameFilter).add(this.componentName);
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        NavigationResult navigationResult;
        Map attributeMap = context.getUIContext().getAttributeMap();
        ComponentDto component = (ComponentDto)this.componentName.getValue();
        String camelComponentName = component.getScheme();
        String previous = (String)attributeMap.get("componentName");
        if (previous != null && previous.equals(camelComponentName) && (navigationResult = (NavigationResult)attributeMap.get("navigationResult")) != null) {
            return navigationResult;
        }
        attributeMap.put("componentName", camelComponentName);
        String currentFile = (String)attributeMap.get("currentFile");
        boolean xmlFile = currentFile != null && currentFile.endsWith(".xml");
        attributeMap.put("mode", "add");
        if (xmlFile) {
            attributeMap.put("xml", currentFile);
            attributeMap.put("kind", "xml");
        } else {
            attributeMap.put("routeBuilder", currentFile);
            attributeMap.put("kind", "java");
        }
        int pos = this.getCurrentCursorPosition(context.getUIContext());
        attributeMap.put("cursorPosition", pos);
        boolean consumerOnly = component.isConsumerOnly();
        boolean producerOnly = component.isProducerOnly();
        UIContext ui = context.getUIContext();
        List<InputOptionByGroup> groups = CamelCommandsHelper.createUIInputsForCamelComponent(camelComponentName, null, 20, consumerOnly, producerOnly, this.getCamelCatalog(), this.componentFactory, this.converterFactory, ui);
        ArrayList<InputComponent> allInputs = new ArrayList<InputComponent>();
        for (InputOptionByGroup group : groups) {
            allInputs.addAll(group.getInputs());
        }
        NavigationResultBuilder builder = Results.navigationBuilder();
        int pages = groups.size();
        for (int i = 0; i < pages; ++i) {
            boolean last = i == pages - 1;
            InputOptionByGroup current = groups.get(i);
            ConfigureEndpointPropertiesStep step = new ConfigureEndpointPropertiesStep(this.projectFactory, this.dependencyInstaller, this.getCamelCatalog(), camelComponentName, current.getGroup(), allInputs, current.getInputs(), last, i, pages);
            builder.add((UICommand)step);
        }
        NavigationResult navigationResult2 = builder.build();
        attributeMap.put("navigationResult", navigationResult2);
        return navigationResult2;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        return null;
    }
}

