/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.completer;

import java.util.Set;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.visit.ResourceVisitor;
import org.jboss.forge.addon.resource.visit.VisitContext;

public class XmlWebResourcesCamelFilesVisitor
implements ResourceVisitor {
    private final WebResourcesFacet facet;
    private final Set<String> files;
    private final Set<String> directories;

    public XmlWebResourcesCamelFilesVisitor(WebResourcesFacet facet, Set<String> files, Set<String> directories) {
        this.facet = facet;
        this.files = files;
        this.directories = directories;
    }

    public void visit(VisitContext visitContext, Resource<?> resource) {
        boolean camel;
        String name = resource.getName();
        if (name.endsWith(".xml") && (camel = resource.getContents().contains("<camelContext"))) {
            int idx;
            String baseDir = this.facet.getWebRootDirectory().getFullyQualifiedName();
            String fqn = resource.getFullyQualifiedName();
            if (fqn.startsWith(baseDir)) {
                fqn = fqn.substring(baseDir.length() + 1);
            }
            if ((idx = Math.max(fqn.lastIndexOf("/"), fqn.lastIndexOf("\\"))) > 0) {
                this.directories.add(fqn.substring(0, idx));
            }
            this.files.add(fqn);
        }
    }
}

