/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.addon.utils.CamelProjectHelper;
import io.fabric8.forge.camel.commands.project.completer.RouteBuilderEndpointsCompleter;
import io.fabric8.forge.camel.commands.project.completer.XmlEndpointsCompleter;
import io.fabric8.forge.camel.commands.project.completer.XmlFileCompleter;
import java.io.PrintStream;
import java.util.Set;
import javax.inject.Inject;
import org.apache.camel.catalog.CamelCatalog;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.Projects;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;

public abstract class AbstractCamelProjectCommand
extends AbstractProjectCommand {
    public static String CATEGORY = "Camel";
    @Inject
    protected ProjectFactory projectFactory;
    @Inject
    protected ConverterFactory converterFactory;
    @Inject
    private CamelCatalog camelCatalog;

    protected boolean isProjectRequired() {
        return true;
    }

    public boolean isEnabled(UIContext context) {
        Project project;
        boolean enabled = super.isEnabled(context);
        if (!enabled) {
            return false;
        }
        if (this.requiresCamelSetup() && (project = this.getSelectedProjectOrNull(context)) != null) {
            return this.findCamelCoreDependency(project) != null;
        }
        return false;
    }

    protected Project getSelectedProjectOrNull(UIContext context) {
        return Projects.getSelectedProject((ProjectFactory)this.getProjectFactory(), (UIContext)context);
    }

    protected boolean requiresCamelSetup() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return this.projectFactory;
    }

    protected ConverterFactory getConverterFactory() {
        return this.converterFactory;
    }

    protected CamelCatalog getCamelCatalog() {
        return this.camelCatalog;
    }

    protected PrintStream getOutput(UIExecutionContext context) {
        return context.getUIContext().getProvider().getOutput().out();
    }

    protected Dependency findCamelCoreDependency(Project project) {
        return CamelProjectHelper.findCamelCoreDependency((Project)project);
    }

    protected Set<Dependency> findCamelArtifacts(Project project) {
        return CamelProjectHelper.findCamelArtifacts((Project)project);
    }

    protected Coordinate createCoordinate(String groupId, String artifactId, String version) {
        CoordinateBuilder builder = CoordinateBuilder.create().setGroupId(groupId).setArtifactId(artifactId);
        if (version != null) {
            builder = builder.setVersion(version);
        }
        return builder;
    }

    protected Coordinate createCamelCoordinate(String artifactId, String version) {
        return this.createCoordinate("org.apache.camel", artifactId, version);
    }

    protected RouteBuilderEndpointsCompleter createRouteBuilderEndpointsCompleter(UIContext context) {
        Project project = this.getSelectedProject(context);
        return this.createRouteBuilderEndpointsCompleter(project);
    }

    protected RouteBuilderEndpointsCompleter createRouteBuilderEndpointsCompleter(Project project) {
        JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        return new RouteBuilderEndpointsCompleter(facet);
    }

    protected XmlEndpointsCompleter createXmlEndpointsCompleter(UIContext context) {
        Project project = this.getSelectedProject(context);
        return this.createXmlEndpointsCompleter(project);
    }

    protected XmlEndpointsCompleter createXmlEndpointsCompleter(Project project) {
        ResourcesFacet resourcesFacet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        WebResourcesFacet webResourcesFacet = null;
        if (project.hasFacet(WebResourcesFacet.class)) {
            webResourcesFacet = (WebResourcesFacet)project.getFacet(WebResourcesFacet.class);
        }
        return new XmlEndpointsCompleter(resourcesFacet, webResourcesFacet);
    }

    protected XmlFileCompleter createXmlFileCompleter(Project project) {
        ResourcesFacet resourcesFacet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        WebResourcesFacet webResourcesFacet = null;
        if (project.hasFacet(WebResourcesFacet.class)) {
            webResourcesFacet = (WebResourcesFacet)project.getFacet(WebResourcesFacet.class);
        }
        return new XmlFileCompleter(resourcesFacet, webResourcesFacet);
    }

    protected XmlFileCompleter createXmlFileCompleter(UIContext context) {
        Project project = this.getSelectedProject(context);
        return this.createXmlFileCompleter(project);
    }
}

