/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.completer;

import io.fabric8.forge.camel.commands.project.helper.XmlRouteParser;
import io.fabric8.forge.camel.commands.project.model.CamelEndpointDetails;
import java.io.InputStream;
import java.util.List;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.visit.ResourceVisitor;
import org.jboss.forge.addon.resource.visit.VisitContext;

public class XmlWebResourcesCamelEndpointsVisitor
implements ResourceVisitor {
    private final WebResourcesFacet facet;
    private final List<CamelEndpointDetails> endpoints;

    public XmlWebResourcesCamelEndpointsVisitor(WebResourcesFacet facet, List<CamelEndpointDetails> endpoints) {
        this.facet = facet;
        this.endpoints = endpoints;
    }

    public void visit(VisitContext visitContext, Resource<?> resource) {
        boolean camel;
        String name = resource.getName();
        if (name.endsWith(".xml") && (camel = resource.getContents().contains("<camelContext"))) {
            try {
                InputStream is = resource.getResourceInputStream();
                String fqn = resource.getFullyQualifiedName();
                String baseDir = this.facet.getWebRootDirectory().getFullyQualifiedName();
                XmlRouteParser.parseXmlRouteEndpoints(is, baseDir, fqn, this.endpoints);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

