/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.completer.CamelDataFormatsCompleter;
import io.fabric8.forge.camel.commands.project.dto.DataFormatDto;
import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import javax.inject.Inject;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.input.ValueChangeListener;
import org.jboss.forge.addon.ui.input.events.ValueChangeEvent;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class CamelAddDataFormatCommand
extends AbstractCamelProjectCommand {
    @Inject
    @WithAttributes(label="Name", required=true, description="Name of dataformat to add")
    private UISelectOne<DataFormatDto> name;
    @Inject
    private DependencyInstaller dependencyInstaller;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelAddDataFormatCommand.class).name("Camel: Add DataFormat").category(Categories.create((String[])new String[]{CATEGORY})).description("Adds a Camel dataformat to your project dependencies");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)builder);
        this.name.setValueChoices(new CamelDataFormatsCompleter(project, this.getCamelCatalog()).getValueChoices());
        this.name.setValueConverter((Converter)new Converter<String, DataFormatDto>(){

            public DataFormatDto convert(String text) {
                return CamelCatalogHelper.createDataFormatDto(CamelAddDataFormatCommand.this.getCamelCatalog(), text);
            }
        });
        this.name.addValueChangeListener(new ValueChangeListener(){

            public void valueChanged(ValueChangeEvent event) {
                DataFormatDto dataFormat = (DataFormatDto)event.getNewValue();
                if (dataFormat != null) {
                    String description = dataFormat.getDescription();
                    CamelAddDataFormatCommand.this.name.setNote(description != null ? description : "");
                } else {
                    CamelAddDataFormatCommand.this.name.setNote("");
                }
            }
        });
        builder.add(this.name);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)context);
        Dependency core = this.findCamelCoreDependency(project);
        if (core == null) {
            return Results.fail((String)"The project does not include camel-core");
        }
        DataFormatDto dto = (DataFormatDto)this.name.getValue();
        if (dto != null) {
            DependencyBuilder component = DependencyBuilder.create().setGroupId(dto.getGroupId()).setArtifactId(dto.getArtifactId()).setVersion(core.getCoordinate().getVersion());
            this.dependencyInstaller.install(project, (Dependency)component);
            return Results.success((String)("Added Camel dataformat " + dto.getName() + " (" + dto.getArtifactId() + ") to the project"));
        }
        return Results.fail((String)"Unknown Camel dataformat");
    }
}

