/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.completer;

import io.fabric8.forge.camel.commands.project.CamelEndpointDetails;
import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import io.fabric8.forge.camel.commands.project.helper.CamelXmlHelper;
import io.fabric8.forge.camel.commands.project.helper.XmlLineNumberParser;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.visit.ResourceVisitor;
import org.jboss.forge.addon.resource.visit.VisitContext;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XmlEndpointsCompleter
implements UICompleter<String> {
    private final List<CamelEndpointDetails> endpoints = new ArrayList<CamelEndpointDetails>();
    private final CamelCatalog camelCatalog = new DefaultCamelCatalog();

    public XmlEndpointsCompleter(final ResourcesFacet facet) {
        facet.visitResources(new ResourceVisitor(){

            public void visit(VisitContext context, Resource<?> resource) {
                boolean camel;
                String name = resource.getName();
                if (name.endsWith(".xml") && (camel = resource.getContents().contains("<camelContext"))) {
                    try {
                        Document dom = XmlLineNumberParser.parseXml(resource.getResourceInputStream());
                        if (dom != null) {
                            List<Node> nodes = CamelXmlHelper.findAllEndpoints(dom);
                            for (Node node : nodes) {
                                String uri = CamelXmlHelper.getSafeAttribute(node, "uri");
                                String id = CamelXmlHelper.getSafeAttribute(node, "id");
                                String lineNumber = (String)node.getUserData("lineNumber");
                                String baseDir = facet.getResourceDirectory().getFullyQualifiedName();
                                String fileName = resource.getFullyQualifiedName();
                                if (fileName.startsWith(baseDir)) {
                                    fileName = fileName.substring(baseDir.length() + 1);
                                }
                                CamelEndpointDetails detail = new CamelEndpointDetails();
                                detail.setResource(resource);
                                detail.setFileName(fileName);
                                detail.setLineNumber(lineNumber);
                                detail.setEndpointInstance(id);
                                detail.setEndpointUri(uri);
                                detail.setEndpointComponentName(CamelCatalogHelper.endpointComponentName(uri));
                                XmlEndpointsCompleter.this.endpoints.add(detail);
                            }
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public List<String> getEndpointUris() {
        ArrayList<String> uris = new ArrayList<String>();
        for (CamelEndpointDetails detail : this.endpoints) {
            uris.add(detail.getEndpointUri());
        }
        return uris;
    }

    public CamelEndpointDetails getEndpointDetail(String uri) {
        for (CamelEndpointDetails detail : this.endpoints) {
            if (!detail.getEndpointUri().equals(uri)) continue;
            return detail;
        }
        return null;
    }

    public Iterable<String> getCompletionProposals(UIContext context, InputComponent input, String value) {
        ArrayList<String> answer = new ArrayList<String>();
        for (CamelEndpointDetails detail : this.endpoints) {
            if (value != null && !detail.getEndpointUri().startsWith(value)) continue;
            answer.add(detail.getEndpointUri());
        }
        return answer;
    }
}

