/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.completer;

import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.visit.ResourceVisitor;
import org.jboss.forge.addon.resource.visit.VisitContext;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;

public class XmlFileCompleter
implements UICompleter<String> {
    private final Set<String> files = new TreeSet<String>();

    public XmlFileCompleter(final ResourcesFacet facet) {
        facet.visitResources(new ResourceVisitor(){

            public void visit(VisitContext context, Resource<?> resource) {
                boolean camel;
                String name = resource.getName();
                if (name.endsWith(".xml") && (camel = resource.getContents().contains("<camelContext"))) {
                    String baseDir = facet.getResourceDirectory().getFullyQualifiedName();
                    String fqn = resource.getFullyQualifiedName();
                    if (fqn.startsWith(baseDir)) {
                        fqn = fqn.substring(baseDir.length() + 1);
                    }
                    XmlFileCompleter.this.files.add(fqn);
                }
            }
        });
    }

    public Set<String> getFiles() {
        return this.files;
    }

    public Iterable<String> getCompletionProposals(UIContext context, InputComponent input, String value) {
        ArrayList<String> answer = new ArrayList<String>();
        for (String name : this.files) {
            if (value != null && !name.startsWith(value)) continue;
            answer.add(name);
        }
        return answer;
    }
}

