/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.CamelComponentDetails;
import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import io.fabric8.forge.camel.commands.project.helper.CamelProjectHelper;
import io.fabric8.forge.camel.commands.project.helper.LineNumberHelper;
import io.fabric8.forge.camel.commands.project.helper.StringHelper;
import io.fabric8.forge.camel.commands.project.helper.UIHelper;
import io.fabric8.forge.camel.commands.project.helper.XmlLineNumberParser;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.catalog.JSonSchemaHelper;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.DependencyResolver;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.util.Strings;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigureEndpointPropertiesStep
extends AbstractCamelProjectCommand
implements UIWizardStep {
    @Inject
    private InputComponentFactory componentFactory;
    @Inject
    private DependencyInstaller dependencyInstaller;
    @Inject
    private DependencyResolver dependencyResolver;
    private List<InputComponent> inputs = new ArrayList<InputComponent>();

    public void initializeUI(UIBuilder builder) throws Exception {
        Map currentValues;
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        Map attributeMap = builder.getUIContext().getAttributeMap();
        String camelComponentName = ConfigureEndpointPropertiesStep.optionalAttributeValue(attributeMap, "componentName");
        String uri = ConfigureEndpointPropertiesStep.optionalAttributeValue(attributeMap, "endpointUri");
        if (camelComponentName == null && uri != null) {
            camelComponentName = CamelCatalogHelper.endpointComponentName(uri);
        }
        if (camelComponentName == null && uri == null) {
            throw new IllegalArgumentException("Component name or endpoint uri did not get passed on from the previous wizard page");
        }
        String json = catalog.componentJSonSchema(camelComponentName);
        if (json == null) {
            throw new IllegalArgumentException("Could not find catalog entry for component name: " + camelComponentName);
        }
        List data = JSonSchemaHelper.parseJsonSchema((String)"properties", (String)json, (boolean)true);
        Map map = currentValues = uri != null ? catalog.endpointProperties(uri) : Collections.EMPTY_MAP;
        if (data != null) {
            HashSet<String> namesAdded = new HashSet<String>();
            for (Map propertyMap : data) {
                InputComponent input;
                Class<Object> inputClazz;
                String name = (String)propertyMap.get("name");
                String kind = (String)propertyMap.get("kind");
                String type = (String)propertyMap.get("type");
                String javaType = (String)propertyMap.get("javaType");
                String deprecated = (String)propertyMap.get("deprecated");
                String required = (String)propertyMap.get("required");
                String currentValue = (String)currentValues.get(name);
                String defaultValue = (String)propertyMap.get("defaultValue");
                String description = (String)propertyMap.get("description");
                String enums = (String)propertyMap.get("enum");
                if (Strings.isNullOrEmpty((String)name) || (inputClazz = CamelCommandsHelper.loadValidInputTypes(javaType, type)) == null || !namesAdded.add(name) || (input = UIHelper.createUIInput(this.componentFactory, name, inputClazz, required, currentValue, defaultValue, enums, description)) == null) continue;
                builder.add(input);
                this.inputs.add(input);
            }
        }
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        return null;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Map attributeMap = context.getUIContext().getAttributeMap();
        String kind = ConfigureEndpointPropertiesStep.mandatoryAttributeValue(attributeMap, "kind");
        if ("xml".equals(kind)) {
            return this.executeXml(context, attributeMap);
        }
        return this.executeJava(context, attributeMap);
    }

    protected Result executeJava(UIExecutionContext context, Map<Object, Object> attributeMap) throws Exception {
        String camelComponentName = ConfigureEndpointPropertiesStep.mandatoryAttributeValue(attributeMap, "componentName");
        String endpointInstanceName = ConfigureEndpointPropertiesStep.mandatoryAttributeValue(attributeMap, "instanceName");
        String routeBuilder = ConfigureEndpointPropertiesStep.mandatoryAttributeValue(attributeMap, "routeBuilder");
        Project project = this.getSelectedProject((UIContextProvider)context);
        JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        Dependency core = CamelProjectHelper.findCamelCoreDependency(project);
        if (core == null) {
            return Results.fail((String)"The project does not include camel-core");
        }
        CamelComponentDetails details = new CamelComponentDetails();
        Result result = CamelCommandsHelper.loadCamelComponentDetails(camelComponentName, details);
        if (result != null) {
            return result;
        }
        result = CamelCommandsHelper.ensureCamelArtifactIdAdded(project, details, this.dependencyInstaller);
        if (result != null) {
            return result;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        for (InputComponent input : this.inputs) {
            String value;
            String key = input.getName();
            if (!input.hasValue() || (value = input.getValue().toString()) == null) continue;
            options.put(key, value);
        }
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        String uri = catalog.asEndpointUri(camelComponentName, options);
        if (uri == null) {
            return Results.fail((String)"Cannot create endpoint uri");
        }
        JavaResource existing = facet.getJavaResource(routeBuilder);
        if (existing == null || !existing.exists()) {
            return Results.fail((String)("RouteBuilder " + routeBuilder + " does not exist"));
        }
        JavaClassSource clazz = (JavaClassSource)existing.getJavaType();
        MethodSource configure = clazz.getMethod("configure");
        String body = configure.getBody();
        clazz.addImport("org.apache.camel.Endpoint");
        if (body == null) {
            body = "";
        }
        String match = String.format("Endpoint %s=", endpointInstanceName);
        List<String> lines = LineNumberHelper.readLines(new StringReader(body));
        int index = -1;
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (!line.trim().startsWith(match)) continue;
            index = i;
            break;
        }
        String line = String.format("Endpoint %s = endpoint(\"%s\");\n\n", endpointInstanceName, uri);
        if (index == -1) {
            lines.add(0, line);
        } else {
            lines.set(index, line);
        }
        String content = LineNumberHelper.linesToString(lines);
        configure.setBody(content);
        facet.saveJavaSource((JavaSource)clazz);
        if (index == -1) {
            return Results.success((String)("Updated endpoint " + endpointInstanceName + " in " + routeBuilder));
        }
        return Results.success((String)("Added endpoint " + endpointInstanceName + " in " + routeBuilder));
    }

    protected Result executeXml(UIExecutionContext context, Map<Object, Object> attributeMap) throws Exception {
        String camelComponentName = ConfigureEndpointPropertiesStep.mandatoryAttributeValue(attributeMap, "componentName");
        String endpointInstanceName = ConfigureEndpointPropertiesStep.mandatoryAttributeValue(attributeMap, "instanceName");
        String xml = ConfigureEndpointPropertiesStep.mandatoryAttributeValue(attributeMap, "xml");
        Project project = this.getSelectedProject((UIContextProvider)context);
        ResourcesFacet facet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        Dependency core = CamelProjectHelper.findCamelCoreDependency(project);
        if (core == null) {
            return Results.fail((String)"The project does not include camel-core");
        }
        CamelComponentDetails details = new CamelComponentDetails();
        Result result = CamelCommandsHelper.loadCamelComponentDetails(camelComponentName, details);
        if (result != null) {
            return result;
        }
        result = CamelCommandsHelper.ensureCamelArtifactIdAdded(project, details, this.dependencyInstaller);
        if (result != null) {
            return result;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        for (InputComponent input : this.inputs) {
            String value;
            String key = input.getName();
            if (!input.hasValue() || (value = input.getValue().toString()) == null) continue;
            options.put(key, value);
        }
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        String uri = catalog.asEndpointUri(camelComponentName, options);
        if (uri == null) {
            return Results.fail((String)"Cannot create endpoint uri");
        }
        uri = StringHelper.replaceAll(uri, "&amp;", "&");
        uri = StringHelper.replaceAll(uri, "&", "&amp;");
        uri = StringHelper.replaceAll(uri, "<", "&lt;");
        uri = StringHelper.replaceAll(uri, ">", "&gt;");
        FileResource file = facet.getResource(xml);
        if (!file.exists()) {
            return Results.fail((String)("Cannot find XML file " + xml));
        }
        Document root = XmlLineNumberParser.parseXml(file.getResourceInputStream());
        if (root != null) {
            NodeList camels = root.getElementsByTagName("camelContext");
            if (camels != null && camels.getLength() == 1) {
                Node camel = camels.item(0);
                Node camelContext = null;
                boolean created = false;
                Node found = null;
                for (int i = 0; i < camel.getChildNodes().getLength(); ++i) {
                    String id;
                    Node child;
                    if ("camelContext".equals(camel.getNodeName())) {
                        camelContext = camel;
                    }
                    if ("camelContext".equals((child = camel.getChildNodes().item(i)).getNodeName())) {
                        camelContext = child;
                    }
                    if (!"endpoint".equals(child.getNodeName()) || !endpointInstanceName.equals(id = child.getAttributes().getNamedItem("id").getNodeValue())) continue;
                    found = child;
                    break;
                }
                int extraSpaces = 0;
                int extraLines = 0;
                if (found == null) {
                    created = true;
                    found = this.insertEndpointBefore(camel);
                    if (found == null) {
                        found = camelContext;
                        extraSpaces = 2;
                        extraLines = 1;
                    }
                }
                if (found == null) {
                    return Results.fail((String)("Cannot find <camelContext> in XML file " + xml));
                }
                String lineNumber = (String)found.getUserData("lineNumber");
                List<String> lines = LineNumberHelper.readLines(file.getResourceInputStream());
                String line = String.format("<endpoint id=\"%s\" uri=\"%s\"/>", endpointInstanceName, uri);
                int idx = lineNumber != null ? Integer.valueOf(lineNumber) - 1 : 0;
                int spaces = LineNumberHelper.leadingSpaces(lines, idx += extraLines) + extraSpaces;
                line = LineNumberHelper.padString(line, spaces);
                if (created) {
                    lines.add(idx, line);
                } else {
                    lines.set(idx, line);
                }
                String content = LineNumberHelper.linesToString(lines);
                file.setContents(content);
                if (created) {
                    return Results.success((String)("Added endpoint: " + endpointInstanceName + " with uri: " + uri));
                }
                return Results.success((String)("Update endpoint: " + endpointInstanceName + " with uri: " + uri));
            }
            return Results.fail((String)("Cannot find <camelContext> in XML file " + xml));
        }
        return Results.fail((String)("Cannot parse XML file " + xml));
    }

    private Node insertEndpointBefore(Node camel) {
        Node endpoint = null;
        for (int i = 0; i < camel.getChildNodes().getLength(); ++i) {
            Node found = camel.getChildNodes().item(i);
            String name = found.getNodeName();
            if (!"endpoint".equals(name)) continue;
            endpoint = found;
        }
        if (endpoint != null) {
            return endpoint;
        }
        Node last = null;
        for (int i = 0; i < camel.getChildNodes().getLength(); ++i) {
            Node found = camel.getChildNodes().item(i);
            String name = found.getNodeName();
            if ("dataFormats".equals(name) || "redeliveryPolicyProfile".equals(name) || "onException".equals(name) || "onCompletion".equals(name) || "intercept".equals(name) || "interceptFrom".equals(name) || "interceptSendToEndpoint".equals(name) || "restConfiguration".equals(name) || "rest".equals(name) || "route".equals(name)) {
                return found;
            }
            if (found.getNodeType() != 1) continue;
            last = found;
        }
        return last;
    }

    public static String mandatoryAttributeValue(Map<Object, Object> attributeMap, String name) {
        String text;
        Object value = attributeMap.get(name);
        if (value != null && !Strings.isBlank((String)(text = value.toString()))) {
            return text;
        }
        throw new IllegalArgumentException("The attribute value '" + name + "' did not get passed on from the previous wizard page");
    }

    public static String optionalAttributeValue(Map<Object, Object> attributeMap, String name) {
        String text;
        Object value = attributeMap.get(name);
        if (value != null && !Strings.isBlank((String)(text = value.toString()))) {
            return text;
        }
        return null;
    }
}

